/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.jmx;

import io.split.cache.SegmentCache;
import io.split.cache.SplitCache;
import io.split.client.SplitClient;
import io.split.client.jmx.SplitJmxMonitorMBean;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.segments.SegmentFetcher;
import io.split.engine.segments.SegmentSynchronizationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class SplitJmxMonitor
implements SplitJmxMonitorMBean {
    private static final Logger _log = LoggerFactory.getLogger(SplitJmxMonitor.class);
    private final SplitClient _client;
    private final SplitFetcher _featureFetcher;
    private final SplitCache _splitCache;
    private final SegmentSynchronizationTask _segmentSynchronizationTask;
    private SegmentCache _segmentCache;

    public SplitJmxMonitor(SplitClient splitClient, SplitFetcher featureFetcher, SplitCache splitCache, SegmentSynchronizationTask segmentSynchronizationTask, SegmentCache segmentCache) {
        this._client = Preconditions.checkNotNull(splitClient);
        this._featureFetcher = Preconditions.checkNotNull(featureFetcher);
        this._splitCache = Preconditions.checkNotNull(splitCache);
        this._segmentSynchronizationTask = Preconditions.checkNotNull(segmentSynchronizationTask);
        this._segmentCache = Preconditions.checkNotNull(segmentCache);
    }

    @Override
    public boolean forceSyncFeatures() {
        this._featureFetcher.forceRefresh(true);
        _log.info("Features successfully refreshed via JMX");
        return true;
    }

    @Override
    public boolean forceSyncSegment(String segmentName) {
        SegmentFetcher fetcher = this._segmentSynchronizationTask.getFetcher(segmentName);
        try {
            fetcher.fetch(true);
        }
        catch (NullPointerException np) {
            throw new NullPointerException();
        }
        _log.info("Segment " + segmentName + " successfully refreshed via JMX");
        return true;
    }

    @Override
    public String getTreatment(String key, String featureName) {
        return this._client.getTreatment(key, featureName);
    }

    @Override
    public String fetchDefinition(String featureName) {
        return this._splitCache.get(featureName).toString();
    }

    @Override
    public boolean isKeyInSegment(String key, String segmentName) {
        return this._segmentCache.isInSegment(segmentName, key);
    }
}

