/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import io.split.cache.SplitCache;
import io.split.engine.experiments.SplitFetcher;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class SplitSynchronizationTask
implements Closeable {
    private static final Logger _log = LoggerFactory.getLogger(SplitSynchronizationTask.class);
    private final AtomicReference<SplitFetcher> _splitFetcher = new AtomicReference();
    private final AtomicReference<SplitCache> _splitCache = new AtomicReference();
    private final AtomicReference<ScheduledExecutorService> _executorService = new AtomicReference();
    private final AtomicLong _refreshEveryNSeconds;
    private final ScheduledExecutorService _scheduledExecutorService;
    private final AtomicBoolean _running;
    private ScheduledFuture<?> _scheduledFuture;

    public SplitSynchronizationTask(SplitFetcher splitFetcher, SplitCache splitCache, long refreshEveryNSeconds) {
        this._splitFetcher.set(Preconditions.checkNotNull(splitFetcher));
        this._splitCache.set(Preconditions.checkNotNull(splitCache));
        Preconditions.checkArgument(refreshEveryNSeconds >= 0L);
        this._refreshEveryNSeconds = new AtomicLong(refreshEveryNSeconds);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("split-splitFetcher-%d").build();
        this._scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this._executorService.set(this._scheduledExecutorService);
        this._running = new AtomicBoolean();
    }

    public void startPeriodicFetching() {
        if (this._running.getAndSet(true)) {
            _log.warn("Splits PeriodicFetching is running...");
            return;
        }
        _log.debug("Starting PeriodicFetching Splits ...");
        this._scheduledFuture = this._scheduledExecutorService.scheduleWithFixedDelay(this._splitFetcher.get(), 0L, this._refreshEveryNSeconds.get(), TimeUnit.SECONDS);
    }

    public void stop() {
        if (!this._running.getAndSet(false) || this._scheduledFuture == null) {
            _log.warn("Splits PeriodicFetching not running...");
            return;
        }
        this._scheduledFuture.cancel(false);
        _log.debug("Stopped PeriodicFetching Splits ...");
    }

    @Override
    public void close() {
        if (this._executorService.get() == null) {
            return;
        }
        if (this._splitFetcher.get() != null) {
            this._splitCache.get().clear();
        }
        this.stop();
        ScheduledExecutorService scheduledExecutorService = this._executorService.get();
        if (scheduledExecutorService.isShutdown()) {
            return;
        }
        scheduledExecutorService.shutdown();
        try {
            if (!scheduledExecutorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                _log.warn("Executor did not terminate in the specified time.");
                List<Runnable> droppedTasks = scheduledExecutorService.shutdownNow();
                _log.warn("Executor was abruptly shut down. These tasks will not be executed: " + droppedTasks);
            }
        }
        catch (InterruptedException e) {
            _log.warn("Shutdown hook for split fetchers has been interrupted");
            Thread.currentThread().interrupt();
        }
    }
}

