/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.workers;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Worker<T>
implements Runnable {
    protected static final Logger _log = LoggerFactory.getLogger(Worker.class);
    private final String _workerName;
    protected final LinkedBlockingQueue<T> _queue = new LinkedBlockingQueue();
    protected AtomicBoolean _running;
    protected Thread _thread;

    public Worker(String workerName) {
        this._workerName = workerName;
        this._running = new AtomicBoolean(false);
    }

    public void start() {
        if (!this._running.compareAndSet(false, true)) {
            _log.debug(String.format("%s Worker already running.", this._workerName));
            return;
        }
        _log.debug(String.format("%s Worker starting ...", this._workerName));
        this._queue.clear();
        this._thread = new Thread(this);
        this._thread.start();
    }

    public void stop() {
        if (this._running.compareAndSet(true, false)) {
            this._thread.interrupt();
            _log.debug(String.format("%s Worked stopped.", this._workerName));
        } else {
            _log.debug(String.format("%s Worker not running.", this._workerName));
        }
    }

    public void addToQueue(T element) {
        if (!this._running.get()) {
            _log.debug("workers not running, ignoring message");
            return;
        }
        try {
            if (!this._running.get()) {
                _log.debug(String.format("%s Worker not running. Can't add items.", this._workerName));
                return;
            }
            this._queue.add(element);
            _log.debug(String.format("Added to %s queue: %s", this._workerName, element.toString()));
        }
        catch (Exception ex) {
            _log.debug(String.format("Exception on %s Worker addToQueue: %s", this._workerName, ex.getMessage()));
        }
    }

    @Override
    public void run() {
        while (this._running.get()) {
            try {
                T element = this._queue.take();
                _log.debug(String.format("Dequeue: %s", element.toString()));
                this.executeRefresh(element);
            }
            catch (InterruptedException ex) {
                _log.debug("The thread was stopped.");
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    protected abstract void executeRefresh(T var1);
}

