/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.cache.SegmentCache;
import io.split.engine.evaluator.Evaluator;
import io.split.engine.matchers.Matcher;
import java.util.Map;
import split.com.google.common.base.Preconditions;

public class UserDefinedSegmentMatcher
implements Matcher {
    private final String _segmentName;
    private final SegmentCache _segmentCache;

    public UserDefinedSegmentMatcher(SegmentCache segmentCache, String segmentName) {
        this._segmentCache = Preconditions.checkNotNull(segmentCache);
        this._segmentName = Preconditions.checkNotNull(segmentName);
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, Evaluator evaluator) {
        if (!(matchValue instanceof String)) {
            return false;
        }
        return this._segmentCache.isInSegment(this._segmentName, (String)matchValue);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._segmentName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserDefinedSegmentMatcher)) {
            return false;
        }
        UserDefinedSegmentMatcher other = (UserDefinedSegmentMatcher)obj;
        return this._segmentName.equals(other._segmentName);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("in segment ");
        bldr.append(this._segmentName);
        return bldr.toString();
    }
}

