/*
 * Decompiled with CFR 0.152.
 */
package io.split.cache;

import io.split.cache.SegmentCache;
import io.split.engine.segments.SegmentImp;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.collect.Maps;

public class SegmentCacheInMemoryImpl
implements SegmentCache {
    private static final Logger _log = LoggerFactory.getLogger(SegmentCacheInMemoryImpl.class);
    private static final long DEFAULT_CHANGE_NUMBER = -1L;
    private final ConcurrentMap<String, SegmentImp> _segments = Maps.newConcurrentMap();

    @Override
    public void updateSegment(String segmentName, List<String> toAdd, List<String> toRemove) {
        if (this._segments.get(segmentName) == null) {
            this._segments.put(segmentName, new SegmentImp(-1L, segmentName, toAdd));
        }
        ((SegmentImp)this._segments.get(segmentName)).update(toAdd, toRemove);
    }

    @Override
    public boolean isInSegment(String segmentName, String key) {
        SegmentImp segmentImp = (SegmentImp)this._segments.get(segmentName);
        if (segmentImp == null) {
            _log.error("Segment " + segmentName + "Not found.");
            return false;
        }
        return segmentImp.contains(key);
    }

    @Override
    public void setChangeNumber(String segmentName, long changeNumber) {
        if (this._segments.get(segmentName) == null) {
            _log.error("Segment " + segmentName + "Not found.");
            return;
        }
        ((SegmentImp)this._segments.get(segmentName)).setChangeNumber(changeNumber);
    }

    @Override
    public long getChangeNumber(String segmentName) {
        SegmentImp segmentImp = (SegmentImp)this._segments.get(segmentName);
        if (segmentImp == null) {
            _log.error("Segment " + segmentName + "Not found.");
            return -1L;
        }
        return segmentImp.getChangeNumber();
    }

    @Override
    public void clear() {
        this._segments.clear();
    }
}

