/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.SplitChange;
import io.split.client.utils.Json;
import io.split.client.utils.Utils;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.engine.metrics.Metrics;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public final class HttpSplitChangeFetcher
implements SplitChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSplitChangeFetcher.class);
    private static final String SINCE = "since";
    private static final String TILL = "till";
    private static final String PREFIX = "splitChangeFetcher";
    private static final String HEADER_CACHE_CONTROL_NAME = "Cache-Control";
    private static final String HEADER_CACHE_CONTROL_VALUE = "no-cache";
    private static final String HEADER_FASTLY_DEBUG_NAME = "Fastly-Debug";
    private static final String HEADER_FASTLY_DEBUG_VALUE = "1";
    private final CloseableHttpClient _client;
    private final URI _target;
    private final Metrics _metrics;

    public static HttpSplitChangeFetcher create(CloseableHttpClient client, URI root) throws URISyntaxException {
        return HttpSplitChangeFetcher.create(client, root, new Metrics.NoopMetrics());
    }

    public static HttpSplitChangeFetcher create(CloseableHttpClient client, URI root, Metrics metrics) throws URISyntaxException {
        return new HttpSplitChangeFetcher(client, Utils.appendPath(root, "api/splitChanges"), metrics);
    }

    private HttpSplitChangeFetcher(CloseableHttpClient client, URI uri, Metrics metrics) {
        this._client = client;
        this._target = uri;
        this._metrics = metrics;
        Preconditions.checkNotNull(this._target);
    }

    long makeRandomTill() {
        return -1L * (long)Math.floor(Math.random() * Math.pow(2.0, 63.0));
    }

    @Override
    public SplitChange fetch(long since, FetchOptions options) {
        SplitChange splitChange;
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(this._target).addParameter(SINCE, "" + since);
            if (options.hasCustomCN()) {
                uriBuilder.addParameter(TILL, "" + options.targetCN());
            }
            URI uri = uriBuilder.build();
            HttpGet request = new HttpGet(uri);
            if (options.cacheControlHeadersEnabled()) {
                request.setHeader(HEADER_CACHE_CONTROL_NAME, (Object)HEADER_CACHE_CONTROL_VALUE);
            }
            if (options.fastlyDebugHeaderEnabled()) {
                request.addHeader(HEADER_FASTLY_DEBUG_NAME, (Object)HEADER_FASTLY_DEBUG_VALUE);
            }
            response = this._client.execute((ClassicHttpRequest)request);
            options.handleResponseHeaders(Arrays.stream(response.getHeaders()).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue)));
            int statusCode = response.getCode();
            if (statusCode < 200 || statusCode >= 300) {
                this._metrics.count("splitChangeFetcher.status." + statusCode, 1L);
                throw new IllegalStateException("Could not retrieve splitChanges; http return code " + statusCode);
            }
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (_log.isDebugEnabled()) {
                _log.debug("Received json: " + json);
            }
            splitChange = Json.fromJson(json, SplitChange.class);
        }
        catch (Throwable t) {
            try {
                this._metrics.count("splitChangeFetcher.exception", 1L);
                throw new IllegalStateException("Problem fetching splitChanges: " + t.getMessage(), t);
            }
            catch (Throwable throwable) {
                Utils.forceClose(response);
                this._metrics.time("splitChangeFetcher.time", System.currentTimeMillis() - start);
                throw throwable;
            }
        }
        Utils.forceClose(response);
        this._metrics.time("splitChangeFetcher.time", System.currentTimeMillis() - start);
        return splitChange;
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }
}

