/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import io.split.cache.SplitCache;
import io.split.client.dtos.Split;
import io.split.client.dtos.SplitChange;
import io.split.client.dtos.Status;
import io.split.engine.SDKReadinessGates;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class SplitFetcherImp
implements SplitFetcher {
    private static final Logger _log = LoggerFactory.getLogger(SplitFetcherImp.class);
    private final SplitParser _parser;
    private final SplitChangeFetcher _splitChangeFetcher;
    private final SplitCache _splitCache;
    private final SDKReadinessGates _gates;
    private final Object _lock = new Object();

    public SplitFetcherImp(SplitChangeFetcher splitChangeFetcher, SplitParser parser, SDKReadinessGates gates, SplitCache splitCache) {
        this._splitChangeFetcher = Preconditions.checkNotNull(splitChangeFetcher);
        this._parser = Preconditions.checkNotNull(parser);
        this._gates = Preconditions.checkNotNull(gates);
        this._splitCache = Preconditions.checkNotNull(splitCache);
    }

    @Override
    public void forceRefresh(FetchOptions options) {
        _log.debug("Force Refresh splits starting ...");
        long INITIAL_CN = this._splitCache.getChangeNumber();
        try {
            long end;
            long start;
            do {
                start = this._splitCache.getChangeNumber();
                this.runWithoutExceptionHandling(options);
                end = this._splitCache.getChangeNumber();
                if (INITIAL_CN != start) continue;
                options = new FetchOptions.Builder(options).targetChangeNumber(FetchOptions.DEFAULT_TARGET_CHANGENUMBER).build();
            } while (start < end);
        }
        catch (InterruptedException e) {
            _log.warn("Interrupting split fetcher task");
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            _log.error("RefreshableSplitFetcher failed: " + t.getMessage());
        }
    }

    @Override
    public void run() {
        this.fetchAll(new FetchOptions.Builder().cacheControlHeaders(false).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithoutExceptionHandling(FetchOptions options) throws InterruptedException {
        SplitChange change = this._splitChangeFetcher.fetch(this._splitCache.getChangeNumber(), options);
        if (change == null) {
            throw new IllegalStateException("SplitChange was null");
        }
        if (change.till == this._splitCache.getChangeNumber()) {
            return;
        }
        if (change.since != this._splitCache.getChangeNumber() || change.till < this._splitCache.getChangeNumber()) {
            return;
        }
        if (change.splits.isEmpty()) {
            this._splitCache.setChangeNumber(change.till);
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (change.since != this._splitCache.getChangeNumber() || change.till < this._splitCache.getChangeNumber()) {
                return;
            }
            for (Split split : change.splits) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (split.status != Status.ACTIVE) {
                    this._splitCache.remove(split.name);
                    continue;
                }
                ParsedSplit parsedSplit = this._parser.parse(split);
                if (parsedSplit == null) {
                    _log.info("We could not parse the experiment definition for: " + split.name + " so we are removing it completely to be careful");
                    this._splitCache.remove(split.name);
                    _log.debug("Deleted feature: " + split.name);
                    continue;
                }
                ParsedSplit current = this._splitCache.get(split.name);
                if (current != null) {
                    this._splitCache.remove(split.name);
                }
                this._splitCache.put(parsedSplit);
                _log.debug("Updated feature: " + parsedSplit.feature());
            }
            this._splitCache.setChangeNumber(change.till);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchAll(FetchOptions options) {
        _log.debug("Fetch splits starting ...");
        long start = this._splitCache.getChangeNumber();
        try {
            this.runWithoutExceptionHandling(options);
            this._gates.splitsAreReady();
        }
        catch (InterruptedException e) {
            _log.warn("Interrupting split fetcher task");
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            _log.error("RefreshableSplitFetcher failed: " + t.getMessage());
            if (_log.isDebugEnabled()) {
                _log.debug("Reason:", t);
            }
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug("split fetch before: " + start + ", after: " + this._splitCache.getChangeNumber());
            }
        }
    }
}

