/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers.collections;

import io.split.engine.evaluator.Evaluator;
import io.split.engine.matchers.Matcher;
import io.split.engine.matchers.Transformers;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ContainsAllOfSetMatcher
implements Matcher {
    private final Set<String> _compareTo = new HashSet<String>();

    public ContainsAllOfSetMatcher(Collection<String> compareTo) {
        if (compareTo == null) {
            throw new IllegalArgumentException("Null whitelist");
        }
        this._compareTo.addAll(compareTo);
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, Evaluator evaluator) {
        if (matchValue == null) {
            return false;
        }
        if (!(matchValue instanceof Collection)) {
            return false;
        }
        if (this._compareTo.isEmpty()) {
            return false;
        }
        Set<String> keyAsSet = Transformers.toSetOfStrings((Collection)matchValue);
        return keyAsSet.containsAll(this._compareTo);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("contains all of ");
        bldr.append(this._compareTo);
        return bldr.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._compareTo.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContainsAllOfSetMatcher)) {
            return false;
        }
        ContainsAllOfSetMatcher other = (ContainsAllOfSetMatcher)obj;
        return this._compareTo.equals(other._compareTo);
    }
}

