/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.memory;

import io.split.client.interceptors.FlagSetsFilter;
import io.split.engine.experiments.ParsedSplit;
import io.split.storages.SplitCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.collect.ConcurrentHashMultiset;
import split.com.google.common.collect.Maps;
import split.com.google.common.collect.Multiset;
import split.com.google.common.collect.Sets;

public class InMemoryCacheImp
implements SplitCache {
    private static final Logger _log = LoggerFactory.getLogger(InMemoryCacheImp.class);
    private final ConcurrentMap<String, ParsedSplit> _concurrentMap = Maps.newConcurrentMap();
    private final ConcurrentMap<String, HashSet<String>> _flagSets;
    private final Multiset<String> _concurrentTrafficTypeNameSet;
    private final FlagSetsFilter _flagSetsFilter;
    private AtomicLong _changeNumber;

    public InMemoryCacheImp(FlagSetsFilter flagSets) {
        this(-1L, flagSets);
    }

    public InMemoryCacheImp(long startingChangeNumber, FlagSetsFilter flagSets) {
        this._changeNumber = new AtomicLong(startingChangeNumber);
        this._concurrentTrafficTypeNameSet = ConcurrentHashMultiset.create();
        this._flagSets = Maps.newConcurrentMap();
        this._flagSetsFilter = flagSets;
    }

    @Override
    public boolean remove(String name) {
        ParsedSplit removed = (ParsedSplit)this._concurrentMap.remove(name);
        if (removed != null) {
            this.removeFromFlagSets(removed.feature());
            if (removed.trafficTypeName() != null) {
                this.decreaseTrafficType(removed.trafficTypeName());
            }
        }
        return removed != null;
    }

    @Override
    public ParsedSplit get(String name) {
        return (ParsedSplit)this._concurrentMap.get(name);
    }

    @Override
    public Collection<ParsedSplit> getAll() {
        return this._concurrentMap.values();
    }

    @Override
    public Map<String, ParsedSplit> fetchMany(List<String> names) {
        HashMap<String, ParsedSplit> splits = new HashMap<String, ParsedSplit>();
        names.forEach(s2 -> splits.put((String)s2, (ParsedSplit)this._concurrentMap.get(s2)));
        return splits;
    }

    @Override
    public long getChangeNumber() {
        return this._changeNumber.get();
    }

    @Override
    public void setChangeNumber(long changeNumber) {
        if (changeNumber < this._changeNumber.get()) {
            _log.error("ChangeNumber for feature flags cache is less than previous");
        }
        this._changeNumber.set(changeNumber);
    }

    @Override
    public boolean trafficTypeExists(String trafficTypeName) {
        return Sets.newHashSet(this._concurrentTrafficTypeNameSet.elementSet()).contains(trafficTypeName);
    }

    @Override
    public List<String> splitNames() {
        ArrayList<String> splitNamesList = new ArrayList<String>();
        for (String key : this._concurrentMap.keySet()) {
            splitNamesList.add(((ParsedSplit)this._concurrentMap.get(key)).feature());
        }
        return splitNamesList;
    }

    @Override
    public Map<String, HashSet<String>> getNamesByFlagSets(List<String> flagSets) {
        HashMap<String, HashSet<String>> toReturn = new HashMap<String, HashSet<String>>();
        for (String set : flagSets) {
            HashSet keys = (HashSet)this._flagSets.get(set);
            if (keys == null) continue;
            toReturn.put(set, keys);
        }
        return toReturn;
    }

    @Override
    public void kill(String splitName, String defaultTreatment, long changeNumber) {
        ParsedSplit parsedSplit = (ParsedSplit)this._concurrentMap.get(splitName);
        ParsedSplit updatedSplit = new ParsedSplit(parsedSplit.feature(), parsedSplit.seed(), true, defaultTreatment, parsedSplit.parsedConditions(), parsedSplit.trafficTypeName(), changeNumber, parsedSplit.trafficAllocation(), parsedSplit.trafficAllocationSeed(), parsedSplit.algo(), parsedSplit.configurations(), parsedSplit.flagSets());
        this._concurrentMap.put(splitName, updatedSplit);
    }

    @Override
    public void clear() {
        this._concurrentMap.clear();
        this._concurrentTrafficTypeNameSet.clear();
    }

    @Override
    public void putMany(List<ParsedSplit> splits) {
        for (ParsedSplit split : splits) {
            this._concurrentMap.put(split.feature(), split);
            if (split.trafficTypeName() != null) {
                this.increaseTrafficType(split.trafficTypeName());
            }
            this.removeFromFlagSets(split.feature());
            this.addToFlagSets(split);
        }
    }

    @Override
    public void increaseTrafficType(String trafficType) {
        this._concurrentTrafficTypeNameSet.add(trafficType);
    }

    @Override
    public void decreaseTrafficType(String trafficType) {
        this._concurrentTrafficTypeNameSet.remove(trafficType);
    }

    @Override
    public void update(List<ParsedSplit> toAdd, List<String> toRemove, long changeNumber) {
        if (toAdd != null) {
            this.putMany(toAdd);
        }
        if (toRemove != null) {
            for (String featureFlag : toRemove) {
                this.remove(featureFlag);
            }
        }
        this.setChangeNumber(changeNumber);
    }

    @Override
    public Set<String> getSegments() {
        return this._concurrentMap.values().stream().flatMap(parsedSplit -> parsedSplit.getSegmentsNames().stream()).collect(Collectors.toSet());
    }

    private void addToFlagSets(ParsedSplit featureFlag) {
        HashSet<String> sets = featureFlag.flagSets();
        if (sets == null) {
            return;
        }
        for (String set : sets) {
            if (!this._flagSetsFilter.intersect(set)) continue;
            HashSet<String> features = (HashSet<String>)this._flagSets.get(set);
            if (features == null) {
                features = new HashSet<String>();
            }
            features.add(featureFlag.feature());
            this._flagSets.put(set, features);
        }
    }

    private void removeFromFlagSets(String featureFlagName) {
        for (String set : this._flagSets.keySet()) {
            ((HashSet)this._flagSets.get(set)).remove(featureFlagName);
        }
    }
}

