/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.hc.core5.http.protocol;

import java.io.IOException;
import split.org.apache.hc.core5.annotation.Contract;
import split.org.apache.hc.core5.annotation.ThreadingBehavior;
import split.org.apache.hc.core5.http.EntityDetails;
import split.org.apache.hc.core5.http.HttpException;
import split.org.apache.hc.core5.http.HttpRequest;
import split.org.apache.hc.core5.http.HttpRequestInterceptor;
import split.org.apache.hc.core5.http.HttpVersion;
import split.org.apache.hc.core5.http.ProtocolVersion;
import split.org.apache.hc.core5.http.protocol.HttpContext;
import split.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && entity != null) {
            ProtocolVersion ver = context.getProtocolVersion();
            if (entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

