/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.events;

import io.split.client.dtos.Event;
import io.split.client.events.EventsStorage;
import io.split.client.events.WrappedEvent;
import io.split.telemetry.domain.enums.EventsDataRecordsEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.gson.internal.$Gson$Preconditions;

public class InMemoryEventsStorage
implements EventsStorage {
    private static final Logger _log = LoggerFactory.getLogger(InMemoryEventsStorage.class);
    private final BlockingQueue<WrappedEvent> _eventQueue;
    private final int _maxQueueSize;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    public InMemoryEventsStorage(int maxQueueSize, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._eventQueue = new LinkedBlockingQueue<WrappedEvent>(maxQueueSize);
        this._maxQueueSize = maxQueueSize;
        this._telemetryRuntimeProducer = $Gson$Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    @Override
    public WrappedEvent pop() {
        try {
            return this._eventQueue.take();
        }
        catch (InterruptedException e) {
            _log.warn("Got interrupted while waiting for an event in the queue.");
            return null;
        }
    }

    @Override
    public List<WrappedEvent> popAll() {
        ArrayList<WrappedEvent> popped = new ArrayList<WrappedEvent>();
        this._eventQueue.drainTo(popped);
        return popped;
    }

    @Override
    public boolean isFull() {
        return this._eventQueue.remainingCapacity() == 0;
    }

    @Override
    public boolean track(Event event, int eventSize) {
        try {
            if (event == null) {
                return false;
            }
            if (!this._eventQueue.offer(new WrappedEvent(event, eventSize))) {
                _log.warn("Event queue is full, dropping event.");
                this._telemetryRuntimeProducer.recordEventStats(EventsDataRecordsEnum.EVENTS_DROPPED, 1L);
                return false;
            }
            this._telemetryRuntimeProducer.recordEventStats(EventsDataRecordsEnum.EVENTS_QUEUED, 1L);
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            this._telemetryRuntimeProducer.recordEventStats(EventsDataRecordsEnum.EVENTS_DROPPED, 1L);
            _log.warn("Interruption when adding event withed while adding message %s.", (Object)event);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    int queueSize() {
        return this._maxQueueSize - this._eventQueue.remainingCapacity();
    }
}

