/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.utils;

import io.split.client.dtos.Split;
import io.split.client.dtos.Status;
import io.split.client.interceptors.FlagSetsFilter;
import io.split.client.utils.FeatureFlagsToUpdate;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlagProcessor {
    private static final Logger _log = LoggerFactory.getLogger(FeatureFlagProcessor.class);

    public static FeatureFlagsToUpdate processFeatureFlagChanges(SplitParser splitParser, List<Split> splits, FlagSetsFilter flagSetsFilter) {
        ArrayList<ParsedSplit> toAdd = new ArrayList<ParsedSplit>();
        ArrayList<String> toRemove = new ArrayList<String>();
        HashSet<String> segments = new HashSet<String>();
        for (Split split : splits) {
            if (split.status != Status.ACTIVE) {
                toRemove.add(split.name);
                continue;
            }
            if (!flagSetsFilter.intersect(split.sets)) {
                toRemove.add(split.name);
                continue;
            }
            ParsedSplit parsedSplit = splitParser.parse(split);
            if (parsedSplit == null) {
                _log.debug(String.format("We could not parse the feature flag definition for: %s", split.name));
                continue;
            }
            segments.addAll(parsedSplit.getSegmentsNames());
            toAdd.add(parsedSplit);
        }
        return new FeatureFlagsToUpdate(toAdd, toRemove, segments);
    }
}

