/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.pluggable.synchronizer;

import io.split.client.SplitClientConfig;
import io.split.client.dtos.UniqueKeys;
import io.split.client.utils.Json;
import io.split.client.utils.SDKMetadata;
import io.split.storages.enums.OperationMode;
import io.split.storages.pluggable.domain.ConfigConsumer;
import io.split.storages.pluggable.domain.PrefixAdapter;
import io.split.storages.pluggable.domain.UserStorageWrapper;
import io.split.telemetry.synchronizer.TelemetrySynchronizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import pluggable.CustomStorageWrapper;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public class TelemetryConsumerSubmitter
implements TelemetrySynchronizer {
    private static final String STORAGE = "PLUGGABLE";
    private final UserStorageWrapper _userStorageWrapper;
    private final SDKMetadata _sdkMetadata;

    public TelemetryConsumerSubmitter(CustomStorageWrapper customStorageWrapper, SDKMetadata sdkMetadata) {
        this._userStorageWrapper = new UserStorageWrapper(Preconditions.checkNotNull(customStorageWrapper));
        this._sdkMetadata = Preconditions.checkNotNull(sdkMetadata);
    }

    @Override
    public void synchronizeConfig(SplitClientConfig config, long timeUntilReady, Map<String, Long> factoryInstances, List<String> tags) {
        String key = String.format("%s/%s/%s", this._sdkMetadata.getSdkVersion(), this._sdkMetadata.getMachineName(), this._sdkMetadata.getMachineIp());
        this._userStorageWrapper.hSet(PrefixAdapter.buildTelemetryInit(), key, Json.toJson(this.generateConfig(config, factoryInstances, tags)));
    }

    @Override
    public void synchronizeStats() {
    }

    @Override
    public void synchronizeUniqueKeys(UniqueKeys uniqueKeys) {
        for (UniqueKeys.UniqueKey uniqueKey : uniqueKeys.uniqueKeys) {
            ArrayList<String> uniqueKeysToSend = new ArrayList<String>(Arrays.asList(Json.toJson(uniqueKey)));
            this._userStorageWrapper.pushItems(PrefixAdapter.buildUniqueKeys(), uniqueKeysToSend);
        }
    }

    @Override
    public void finalSynchronization() {
    }

    @VisibleForTesting
    ConfigConsumer generateConfig(SplitClientConfig splitClientConfig, Map<String, Long> factoryInstances, List<String> tags) {
        ConfigConsumer config = new ConfigConsumer();
        config.setOperationMode(splitClientConfig.operationMode() == OperationMode.STANDALONE ? 0 : 1);
        config.setStorage(STORAGE);
        config.setActiveFactories(factoryInstances.size());
        config.setRedundantFactories(this.getRedundantFactories(factoryInstances));
        config.setTags(tags.size() < 10 ? tags : tags.subList(0, 10));
        int invalidSets = splitClientConfig.getInvalidSets();
        config.setFlagSetsTotal(splitClientConfig.getSetsFilter().size() + invalidSets);
        config.setFlagSetsInvalid(invalidSets);
        return config;
    }

    private long getRedundantFactories(Map<String, Long> factoryInstances) {
        return factoryInstances.values().stream().mapToLong(l -> l - 1L).sum();
    }
}

