/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.LocalhostSplit;
import io.split.client.SplitAndKey;
import io.split.client.dtos.ConditionType;
import io.split.client.dtos.MatcherCombiner;
import io.split.client.dtos.Partition;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.matchers.AllKeysMatcher;
import io.split.engine.matchers.AttributeMatcher;
import io.split.engine.matchers.CombiningMatcher;
import io.split.engine.matchers.strings.WhitelistMatcher;
import io.split.storages.SplitCacheProducer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import split.com.google.common.base.Preconditions;
import split.com.google.common.collect.Lists;

public final class CacheUpdaterService {
    private static String LOCALHOST = "localhost";
    private SplitCacheProducer _splitCacheProducer;

    public CacheUpdaterService(SplitCacheProducer splitCacheProducer) {
        this._splitCacheProducer = Preconditions.checkNotNull(splitCacheProducer);
    }

    public void updateCache(Map<SplitAndKey, LocalhostSplit> map) {
        this._splitCacheProducer.clear();
        ArrayList<ParsedSplit> parsedSplits = new ArrayList<ParsedSplit>();
        for (Map.Entry<SplitAndKey, LocalhostSplit> entrySplit : map.entrySet()) {
            List<ParsedCondition> conditions;
            SplitAndKey splitAndKey = entrySplit.getKey();
            String splitName = splitAndKey.split();
            String splitKey = splitAndKey.key();
            LocalhostSplit localhostSplit = entrySplit.getValue();
            Optional<ParsedSplit> splitOptional = parsedSplits.stream().filter(ps -> ps.feature().equals(splitName)).findFirst();
            ParsedSplit split = splitOptional.orElse(null);
            Map<Object, Object> configurations = new HashMap();
            if (split != null && split.configurations().size() > 0) {
                configurations = split.configurations();
            }
            String treatment = (conditions = this.getConditions(splitKey, split, localhostSplit.treatment)).size() > 0 ? "control" : localhostSplit.treatment;
            configurations.put(localhostSplit.treatment, localhostSplit.config);
            split = new ParsedSplit(splitName, 0, false, treatment, conditions, LOCALHOST, 0L, 100, 0, 0, configurations, new HashSet<String>());
            parsedSplits.removeIf(parsedSplit -> parsedSplit.feature().equals(splitName));
            parsedSplits.add(split);
        }
        this._splitCacheProducer.putMany(parsedSplits);
        this._splitCacheProducer.setChangeNumber(this._splitCacheProducer.getChangeNumber());
    }

    private List<ParsedCondition> getConditions(String splitKey, ParsedSplit split, String treatment) {
        List<Object> conditions = split == null ? new ArrayList<ParsedCondition>() : new ArrayList<ParsedCondition>(split.parsedConditions());
        Partition partition = new Partition();
        partition.treatment = treatment;
        partition.size = 100;
        if (splitKey != null) {
            conditions.add(this.createWhitelistCondition(splitKey, partition));
        } else {
            conditions = conditions.stream().filter(pc -> ConditionType.WHITELIST.equals((Object)pc.conditionType())).collect(Collectors.toList());
            conditions.add(this.createRolloutCondition(partition));
        }
        conditions.sort(Comparator.comparing(ParsedCondition::conditionType));
        return conditions;
    }

    private ParsedCondition createWhitelistCondition(String splitKey, Partition partition) {
        ParsedCondition parsedCondition = new ParsedCondition(ConditionType.WHITELIST, new CombiningMatcher(MatcherCombiner.AND, Lists.newArrayList(new AttributeMatcher(null, new WhitelistMatcher(Lists.newArrayList(splitKey)), false))), Lists.newArrayList(partition), splitKey);
        return parsedCondition;
    }

    private ParsedCondition createRolloutCondition(Partition partition) {
        Partition rolloutPartition = new Partition();
        rolloutPartition.treatment = "-";
        rolloutPartition.size = 0;
        ParsedCondition parsedCondition = new ParsedCondition(ConditionType.ROLLOUT, new CombiningMatcher(MatcherCombiner.AND, Lists.newArrayList(new AttributeMatcher(null, new AllKeysMatcher(), false))), Lists.newArrayList(partition, rolloutPartition), "LOCAL");
        return parsedCondition;
    }
}

