/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.dtos;

import io.split.client.dtos.Split;
import io.split.client.utils.Json;
import io.split.engine.segments.SegmentSynchronizationTaskImp;
import io.split.engine.sse.NotificationProcessor;
import io.split.engine.sse.dtos.GenericNotificationData;
import io.split.engine.sse.dtos.IncomingNotification;
import io.split.engine.sse.enums.CompressType;
import io.split.engine.sse.utils.DecompressionUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.zip.DataFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlagChangeNotification
extends IncomingNotification {
    private static final Logger _log = LoggerFactory.getLogger(SegmentSynchronizationTaskImp.class);
    private final long changeNumber;
    private long previousChangeNumber;
    private Split featureFlagDefinition;
    private CompressType compressType;

    public FeatureFlagChangeNotification(GenericNotificationData genericNotificationData) {
        super(IncomingNotification.Type.SPLIT_UPDATE, genericNotificationData.getChannel());
        this.changeNumber = genericNotificationData.getChangeNumber();
        if (genericNotificationData.getPreviousChangeNumber() != null) {
            this.previousChangeNumber = genericNotificationData.getPreviousChangeNumber();
        }
        this.compressType = CompressType.from(genericNotificationData.getCompressType());
        if (this.compressType == null || genericNotificationData.getFeatureFlagDefinition() == null) {
            return;
        }
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(genericNotificationData.getFeatureFlagDefinition());
            switch (this.compressType) {
                case GZIP: {
                    decodedBytes = DecompressionUtil.gZipDecompress(decodedBytes);
                    break;
                }
                case ZLIB: {
                    decodedBytes = DecompressionUtil.zLibDecompress(decodedBytes);
                }
            }
            this.featureFlagDefinition = Json.fromJson(new String(decodedBytes, 0, decodedBytes.length, "UTF-8"), Split.class);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            _log.warn("Could not decode base64 data in flag definition", (Throwable)e);
        }
        catch (DataFormatException d) {
            _log.warn("Could not decompress feature flag definition with zlib algorithm", (Throwable)d);
        }
        catch (IOException i) {
            _log.warn("Could not decompress feature flag definition with gzip algorithm", (Throwable)i);
        }
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public long getPreviousChangeNumber() {
        return this.previousChangeNumber;
    }

    public Split getFeatureFlagDefinition() {
        return this.featureFlagDefinition;
    }

    public CompressType getCompressType() {
        return this.compressType;
    }

    @Override
    public void handler(NotificationProcessor notificationProcessor) {
        notificationProcessor.processSplitUpdate(this);
    }

    public String toString() {
        return String.format("Type: %s; Channel: %s; ChangeNumber: %s", new Object[]{this.getType(), this.getChannel(), this.getChangeNumber()});
    }
}

