/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.workers;

import io.split.client.dtos.Split;
import io.split.client.interceptors.FlagSetsFilter;
import io.split.client.utils.FeatureFlagProcessor;
import io.split.client.utils.FeatureFlagsToUpdate;
import io.split.engine.common.Synchronizer;
import io.split.engine.experiments.SplitParser;
import io.split.engine.sse.dtos.FeatureFlagChangeNotification;
import io.split.engine.sse.dtos.SplitKillNotification;
import io.split.engine.sse.workers.FeatureFlagsWorker;
import io.split.engine.sse.workers.Worker;
import io.split.storages.SplitCacheProducer;
import io.split.telemetry.domain.enums.UpdatesFromSSEEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class FeatureFlagWorkerImp
extends Worker<FeatureFlagChangeNotification>
implements FeatureFlagsWorker {
    private static final Logger _log = LoggerFactory.getLogger(FeatureFlagWorkerImp.class);
    private final Synchronizer _synchronizer;
    private final SplitParser _splitParser;
    private final SplitCacheProducer _splitCacheProducer;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;
    private final FlagSetsFilter _flagSetsFilter;

    public FeatureFlagWorkerImp(Synchronizer synchronizer, SplitParser splitParser, SplitCacheProducer splitCacheProducer, TelemetryRuntimeProducer telemetryRuntimeProducer, FlagSetsFilter flagSetsFilter) {
        super("Feature flags");
        this._synchronizer = Preconditions.checkNotNull(synchronizer);
        this._splitParser = splitParser;
        this._splitCacheProducer = splitCacheProducer;
        this._telemetryRuntimeProducer = telemetryRuntimeProducer;
        this._flagSetsFilter = flagSetsFilter;
    }

    @Override
    public void kill(SplitKillNotification splitKillNotification) {
        try {
            this._synchronizer.localKillSplit(splitKillNotification);
            _log.debug(String.format("Kill feature flag: %s, changeNumber: %s, defaultTreatment: %s", splitKillNotification.getSplitName(), splitKillNotification.getChangeNumber(), splitKillNotification.getDefaultTreatment()));
        }
        catch (Exception ex) {
            _log.warn(String.format("Exception on FeatureFlagWorker kill: %s", ex.getMessage()));
        }
    }

    @Override
    protected void executeRefresh(FeatureFlagChangeNotification featureFlagChangeNotification) {
        boolean success = this.addOrUpdateFeatureFlag(featureFlagChangeNotification);
        if (!success) {
            this._synchronizer.refreshSplits(featureFlagChangeNotification.getChangeNumber());
        }
    }

    private boolean addOrUpdateFeatureFlag(FeatureFlagChangeNotification featureFlagChangeNotification) {
        if (featureFlagChangeNotification.getChangeNumber() <= this._splitCacheProducer.getChangeNumber()) {
            return true;
        }
        try {
            if (featureFlagChangeNotification.getFeatureFlagDefinition() != null && featureFlagChangeNotification.getPreviousChangeNumber() == this._splitCacheProducer.getChangeNumber()) {
                Split featureFlag = featureFlagChangeNotification.getFeatureFlagDefinition();
                FeatureFlagsToUpdate featureFlagsToUpdate = FeatureFlagProcessor.processFeatureFlagChanges(this._splitParser, Collections.singletonList(featureFlag), this._flagSetsFilter);
                this._splitCacheProducer.update(featureFlagsToUpdate.getToAdd(), featureFlagsToUpdate.getToRemove(), featureFlagChangeNotification.getChangeNumber());
                Set<String> segments = featureFlagsToUpdate.getSegments();
                for (String segmentName : segments) {
                    this._synchronizer.forceRefreshSegment(segmentName);
                }
                this._telemetryRuntimeProducer.recordUpdatesFromSSE(UpdatesFromSSEEnum.SPLITS);
                return true;
            }
        }
        catch (Exception e) {
            _log.warn("Something went wrong processing a Feature Flag notification", (Throwable)e);
        }
        return false;
    }
}

