/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.SegmentChange;
import io.split.client.utils.Json;
import io.split.client.utils.Utils;
import io.split.engine.common.FetchOptions;
import io.split.engine.segments.SegmentChangeFetcher;
import io.split.telemetry.domain.enums.HTTPLatenciesEnum;
import io.split.telemetry.domain.enums.LastSynchronizationRecordsEnum;
import io.split.telemetry.domain.enums.ResourceEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.org.apache.hc.client5.http.classic.methods.HttpGet;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import split.org.apache.hc.core5.http.io.entity.EntityUtils;
import split.org.apache.hc.core5.net.URIBuilder;

public final class HttpSegmentChangeFetcher
implements SegmentChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSegmentChangeFetcher.class);
    private static final String SINCE = "since";
    private static final String TILL = "till";
    private static final String PREFIX = "segmentChangeFetcher";
    private static final String CACHE_CONTROL_HEADER_NAME = "Cache-Control";
    private static final String CACHE_CONTROL_HEADER_VALUE = "no-cache";
    private final CloseableHttpClient _client;
    private final URI _target;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    public static HttpSegmentChangeFetcher create(CloseableHttpClient client, URI root, TelemetryRuntimeProducer telemetryRuntimeProducer) throws URISyntaxException {
        return new HttpSegmentChangeFetcher(client, Utils.appendPath(root, "api/segmentChanges"), telemetryRuntimeProducer);
    }

    private HttpSegmentChangeFetcher(CloseableHttpClient client, URI uri, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._client = client;
        this._target = uri;
        Preconditions.checkNotNull(this._target);
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    @Override
    public SegmentChange fetch(String segmentName, long since, FetchOptions options) {
        SegmentChange segmentChange;
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = null;
        try {
            String path = this._target.getPath() + "/" + segmentName;
            URIBuilder uriBuilder = new URIBuilder(this._target).setPath(path).addParameter(SINCE, "" + since);
            if (options.hasCustomCN()) {
                uriBuilder.addParameter(TILL, "" + options.targetCN());
            }
            URI uri = uriBuilder.build();
            HttpGet request = new HttpGet(uri);
            if (options.cacheControlHeadersEnabled()) {
                request.setHeader(CACHE_CONTROL_HEADER_NAME, CACHE_CONTROL_HEADER_VALUE);
            }
            response = this._client.execute(request);
            int statusCode = response.getCode();
            if (_log.isDebugEnabled()) {
                _log.debug(String.format("[%s] %s. Status code: %s", request.getMethod(), uri.toURL(), statusCode));
            }
            if (statusCode < 200 || statusCode >= 300) {
                this._telemetryRuntimeProducer.recordSyncError(ResourceEnum.SEGMENT_SYNC, statusCode);
                _log.error(String.format("Response status was: %s. Reason: %s", statusCode, response.getReasonPhrase()));
                if (statusCode == 403) {
                    _log.error("factory instantiation: you passed a client side type sdkKey, please grab an sdk key from the Split user interface that is of type server side");
                }
                throw new IllegalStateException(String.format("Could not retrieve segment changes for %s, since %s; http return code %s", segmentName, since, statusCode));
            }
            this._telemetryRuntimeProducer.recordSuccessfulSync(LastSynchronizationRecordsEnum.SEGMENTS, System.currentTimeMillis());
            String json = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            segmentChange = Json.fromJson(json, SegmentChange.class);
            this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.SEGMENTS, System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(String.format("Error occurred when trying to sync segment: %s, since: %s. Details: %s", segmentName, since, e), e);
            }
            catch (Throwable throwable) {
                this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.SEGMENTS, System.currentTimeMillis() - start);
                Utils.forceClose(response);
                throw throwable;
            }
        }
        Utils.forceClose(response);
        return segmentChange;
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }
}

