/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.SplitChange;
import io.split.client.exceptions.UriTooLongException;
import io.split.client.utils.Json;
import io.split.client.utils.Utils;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.telemetry.domain.enums.HTTPLatenciesEnum;
import io.split.telemetry.domain.enums.ResourceEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.org.apache.hc.client5.http.classic.methods.HttpGet;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import split.org.apache.hc.core5.http.io.entity.EntityUtils;
import split.org.apache.hc.core5.net.URIBuilder;

public final class HttpSplitChangeFetcher
implements SplitChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSplitChangeFetcher.class);
    private static final String SINCE = "since";
    private static final String TILL = "till";
    private static final String SETS = "sets";
    private static final String HEADER_CACHE_CONTROL_NAME = "Cache-Control";
    private static final String HEADER_CACHE_CONTROL_VALUE = "no-cache";
    private final CloseableHttpClient _client;
    private final URI _target;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    public static HttpSplitChangeFetcher create(CloseableHttpClient client, URI root, TelemetryRuntimeProducer telemetryRuntimeProducer) throws URISyntaxException {
        return new HttpSplitChangeFetcher(client, Utils.appendPath(root, "api/splitChanges"), telemetryRuntimeProducer);
    }

    private HttpSplitChangeFetcher(CloseableHttpClient client, URI uri, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._client = client;
        this._target = uri;
        Preconditions.checkNotNull(this._target);
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    long makeRandomTill() {
        return -1L * (long)Math.floor(Math.random() * Math.pow(2.0, 63.0));
    }

    @Override
    public SplitChange fetch(long since, FetchOptions options) {
        SplitChange splitChange;
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(this._target).addParameter(SINCE, "" + since);
            if (options.hasCustomCN()) {
                uriBuilder.addParameter(TILL, "" + options.targetCN());
            }
            if (!options.flagSetsFilter().isEmpty()) {
                uriBuilder.addParameter(SETS, "" + options.flagSetsFilter());
            }
            URI uri = uriBuilder.build();
            HttpGet request = new HttpGet(uri);
            if (options.cacheControlHeadersEnabled()) {
                request.setHeader(HEADER_CACHE_CONTROL_NAME, HEADER_CACHE_CONTROL_VALUE);
            }
            response = this._client.execute(request);
            int statusCode = response.getCode();
            if (_log.isDebugEnabled()) {
                _log.debug(String.format("[%s] %s. Status code: %s", request.getMethod(), uri.toURL(), statusCode));
            }
            if (statusCode < 200 || statusCode >= 300) {
                this._telemetryRuntimeProducer.recordSyncError(ResourceEnum.SPLIT_SYNC, statusCode);
                if (statusCode == 414) {
                    _log.error("The amount of flag sets provided are big causing uri length error.");
                    throw new UriTooLongException(String.format("Status code: %s. Message: %s", statusCode, response.getReasonPhrase()));
                }
                _log.warn(String.format("Response status was: %s. Reason: %s", statusCode, response.getReasonPhrase()));
                throw new IllegalStateException(String.format("Could not retrieve splitChanges since %s; http return code %s", since, statusCode));
            }
            String json = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            splitChange = Json.fromJson(json, SplitChange.class);
            this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.SPLITS, System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(String.format("Problem fetching splitChanges since %s: %s", since, e), e);
            }
            catch (Throwable throwable) {
                this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.SPLITS, System.currentTimeMillis() - start);
                Utils.forceClose(response);
                throw throwable;
            }
        }
        Utils.forceClose(response);
        return splitChange;
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }
}

