/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import io.split.engine.common.FetchOptions;
import io.split.engine.common.SplitTasks;
import io.split.engine.common.Synchronizer;
import io.split.engine.experiments.FetchResult;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitSynchronizationTask;
import io.split.engine.segments.SegmentFetcher;
import io.split.engine.segments.SegmentSynchronizationTask;
import io.split.engine.sse.dtos.SplitKillNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class LocalhostSynchronizer
implements Synchronizer {
    private static final Logger _log = LoggerFactory.getLogger(LocalhostSynchronizer.class);
    private final SplitSynchronizationTask _splitSynchronizationTask;
    private final SplitFetcher _splitFetcher;
    private final SegmentSynchronizationTask _segmentSynchronizationTaskImp;
    private final boolean _refreshEnable;

    public LocalhostSynchronizer(SplitTasks splitTasks, SplitFetcher splitFetcher, boolean refreshEnable) {
        this._splitSynchronizationTask = Preconditions.checkNotNull(splitTasks.getSplitSynchronizationTask());
        this._splitFetcher = Preconditions.checkNotNull(splitFetcher);
        this._segmentSynchronizationTaskImp = splitTasks.getSegmentSynchronizationTask();
        this._refreshEnable = refreshEnable;
    }

    @Override
    public boolean syncAll() {
        FetchResult fetchResult = this._splitFetcher.forceRefresh(new FetchOptions.Builder().cacheControlHeaders(true).build());
        return fetchResult.isSuccess() && this._segmentSynchronizationTaskImp.fetchAllSynchronous();
    }

    @Override
    public void startPeriodicFetching() {
        _log.debug("Starting Periodic Fetching ...");
        if (!this._refreshEnable) {
            _log.info("Refresh enable is false. The synchronization tasks are not going to start");
            return;
        }
        this._splitSynchronizationTask.start();
        this._segmentSynchronizationTaskImp.start();
    }

    @Override
    public void stopPeriodicFetching() {
        _log.debug("Stop Periodic Fetching ...");
        if (!this._refreshEnable) {
            return;
        }
        this._splitSynchronizationTask.stop();
        this._segmentSynchronizationTaskImp.stop();
    }

    @Override
    public void refreshSplits(Long targetChangeNumber) {
        FetchResult fetchResult = this._splitFetcher.forceRefresh(new FetchOptions.Builder().cacheControlHeaders(true).build());
        if (fetchResult.isSuccess()) {
            _log.debug("Refresh feature flags completed");
            fetchResult.getSegments().stream().forEach(segmentName -> this.refreshSegment((String)segmentName, null));
        } else {
            _log.debug("No changes fetched");
        }
    }

    @Override
    public void localKillSplit(SplitKillNotification splitKillNotification) {
    }

    @Override
    public void refreshSegment(String segmentName, Long targetChangeNumber) {
        SegmentFetcher segmentFetcher = this._segmentSynchronizationTaskImp.getFetcher(segmentName);
        segmentFetcher.fetch(new FetchOptions.Builder().cacheControlHeaders(true).build());
    }

    @Override
    public void startPeriodicDataRecording() {
    }

    @Override
    public void stopPeriodicDataRecording() {
    }

    @Override
    public void forceRefreshSegment(String segmentName) {
    }
}

