/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.dtos;

import io.split.client.utils.Json;
import io.split.engine.sse.dtos.Jwt;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import split.com.google.gson.JsonElement;
import split.com.google.gson.JsonObject;

public class RawAuthResponse {
    private static final Integer PUSH_SECONDS_BEFORE_EXPIRATION = 600;
    private final boolean pushEnabled;
    private final String token;
    private final Jwt jwt;

    public RawAuthResponse(boolean pushEnabled, String token) {
        this.pushEnabled = pushEnabled;
        this.token = token;
        if (token != null && token != "") {
            String tokenDecoded = this.decodeJwt();
            this.jwt = Json.fromJson(tokenDecoded, Jwt.class);
        } else {
            this.jwt = null;
        }
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    public String getToken() {
        return this.token;
    }

    public String getChannels() {
        ArrayList channelsList = new ArrayList();
        JsonObject jsonObject = Json.fromJson(this.jwt.getCapability(), JsonObject.class);
        Set<Map.Entry<String, JsonElement>> entries = jsonObject.entrySet();
        entries.forEach(e -> channelsList.add((String)e.getKey()));
        return this.addPrefixControlChannels(String.join((CharSequence)",", channelsList));
    }

    public long getExpiration() {
        return this.jwt.getExpiration() - this.jwt.getIssueAt() - (long)PUSH_SECONDS_BEFORE_EXPIRATION.intValue();
    }

    private String decodeJwt() {
        String[] splitToken = this.token.split("\\.");
        String encodedString = splitToken[1];
        byte[] decodedBytes = Base64.getDecoder().decode(encodedString);
        return new String(decodedBytes);
    }

    private String addPrefixControlChannels(String channels) {
        return channels.replace("control_pri", "[?occupancy=metrics.publishers]control_pri").replace("control_sec", "[?occupancy=metrics.publishers]control_sec");
    }
}

