/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.utils.FileTypeEnum;
import io.split.inputValidation.FlagSetsValidator;
import io.split.integrations.IntegrationsConfig;
import io.split.storages.enums.OperationMode;
import io.split.storages.enums.StorageMode;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import pluggable.CustomStorageWrapper;
import split.org.apache.hc.core5.http.HttpHost;

public class SplitClientConfig {
    public static final String LOCALHOST_DEFAULT_FILE = "split.yaml";
    public static final String SDK_ENDPOINT = "https://sdk.split.io";
    public static final String EVENTS_ENDPOINT = "https://events.split.io";
    public static final String AUTH_ENDPOINT = "https://auth.split.io/api/v2/auth";
    public static final String STREAMING_ENDPOINT = "https://streaming.split.io/sse";
    public static final String TELEMETRY_ENDPOINT = "https://telemetry.split.io/api/v1";
    private final String _endpoint;
    private final String _eventsEndpoint;
    private final int _featuresRefreshRate;
    private final int _segmentsRefreshRate;
    private final int _impressionsRefreshRate;
    private final int _impressionsQueueSize;
    private final ImpressionsManager.Mode _impressionsMode;
    private final int _metricsRefreshRate;
    private final int _connectionTimeout;
    private final int _readTimeout;
    private final int _numThreadsForSegmentFetch;
    private final boolean _debugEnabled;
    private final boolean _labelsEnabled;
    private final boolean _ipAddressEnabled;
    private final boolean _localhostRefreshEnabled;
    private final int _ready;
    private final int _waitBeforeShutdown;
    private final int _eventsQueueSize;
    private final long _eventSendIntervalInMillis;
    private final int _maxStringLength;
    private final boolean _destroyOnShutDown;
    private final String _splitFile;
    private final FileTypeEnum _fileType;
    private final InputStream _inputStream;
    private final String _segmentDirectory;
    private final IntegrationsConfig _integrationsConfig;
    private final boolean _streamingEnabled;
    private final int _authRetryBackoffBase;
    private final int _streamingReconnectBackoffBase;
    private final String _authServiceURL;
    private final String _streamingServiceURL;
    private final String _telemetryURL;
    private final int _telemetryRefreshRate;
    private final int _onDemandFetchRetryDelayMs;
    private final int _onDemandFetchMaxRetries;
    private final int _failedAttemptsBeforeLogging;
    private final int _uniqueKeysRefreshRateInMemory;
    private final int _uniqueKeysRefreshRateRedis;
    private static int _filterUniqueKeysRefreshRate;
    private final OperationMode _operationMode;
    private long _validateAfterInactivityInMillis;
    private final long _startingSyncCallBackoffBaseMs;
    private final CustomStorageWrapper _customStorageWrapper;
    private final StorageMode _storageMode;
    private final ThreadFactory _threadFactory;
    private final HttpHost _proxy;
    private final String _proxyUsername;
    private final String _proxyPassword;
    public static String splitSdkVersion;
    private final long _lastSeenCacheSize;
    private final HashSet<String> _flagSetsFilter;
    private final int _invalidSets;

    public static Builder builder() {
        return new Builder();
    }

    private SplitClientConfig(String endpoint, String eventsEndpoint, int pollForFeatureChangesEveryNSeconds, int segmentsRefreshRate, int impressionsRefreshRate, int impressionsQueueSize, ImpressionsManager.Mode impressionsMode, int metricsRefreshRate, int connectionTimeout, int readTimeout, int numThreadsForSegmentFetch, int ready, boolean debugEnabled, boolean labelsEnabled, boolean ipAddressEnabled, boolean localhostRefreshEnabled, int waitBeforeShutdown, HttpHost proxy, String proxyUsername, String proxyPassword, int eventsQueueSize, long eventSendIntervalInMillis, int maxStringLength, boolean destroyOnShutDown, String splitFile, FileTypeEnum fileType, InputStream inputStream, String segmentDirectory, IntegrationsConfig integrationsConfig, boolean streamingEnabled, int authRetryBackoffBase, int streamingReconnectBackoffBase, String authServiceURL, String streamingServiceURL, String telemetryURL, int telemetryRefreshRate, int onDemandFetchRetryDelayMs, int onDemandFetchMaxRetries, int failedAttemptsBeforeLogging, OperationMode operationMode, long validateAfterInactivityInMillis, long startingSyncCallBackoffBaseMs, CustomStorageWrapper customStorageWrapper, StorageMode storageMode, int uniqueKeysRefreshRateInMemory, int uniqueKeysRefreshRateRedis, int filterUniqueKeysRefreshRate, long lastSeenCacheSize, ThreadFactory threadFactory, HashSet<String> flagSetsFilter, int invalidSets) {
        this._endpoint = endpoint;
        this._eventsEndpoint = eventsEndpoint;
        this._featuresRefreshRate = pollForFeatureChangesEveryNSeconds;
        this._segmentsRefreshRate = segmentsRefreshRate;
        this._impressionsRefreshRate = impressionsRefreshRate;
        this._impressionsQueueSize = impressionsQueueSize;
        this._impressionsMode = impressionsMode;
        this._metricsRefreshRate = metricsRefreshRate;
        this._connectionTimeout = connectionTimeout;
        this._readTimeout = readTimeout;
        this._numThreadsForSegmentFetch = numThreadsForSegmentFetch;
        this._ready = ready;
        this._debugEnabled = debugEnabled;
        this._labelsEnabled = labelsEnabled;
        this._ipAddressEnabled = ipAddressEnabled;
        this._localhostRefreshEnabled = localhostRefreshEnabled;
        this._waitBeforeShutdown = waitBeforeShutdown;
        this._proxy = proxy;
        this._proxyUsername = proxyUsername;
        this._proxyPassword = proxyPassword;
        this._eventsQueueSize = eventsQueueSize;
        this._eventSendIntervalInMillis = eventSendIntervalInMillis;
        this._maxStringLength = maxStringLength;
        this._destroyOnShutDown = destroyOnShutDown;
        this._splitFile = splitFile;
        this._fileType = fileType;
        this._inputStream = inputStream;
        this._segmentDirectory = segmentDirectory;
        this._integrationsConfig = integrationsConfig;
        this._streamingEnabled = streamingEnabled;
        this._authRetryBackoffBase = authRetryBackoffBase;
        this._streamingReconnectBackoffBase = streamingReconnectBackoffBase;
        this._authServiceURL = authServiceURL;
        this._streamingServiceURL = streamingServiceURL;
        this._telemetryURL = telemetryURL;
        this._telemetryRefreshRate = telemetryRefreshRate;
        this._uniqueKeysRefreshRateInMemory = uniqueKeysRefreshRateInMemory;
        this._uniqueKeysRefreshRateRedis = uniqueKeysRefreshRateRedis;
        _filterUniqueKeysRefreshRate = filterUniqueKeysRefreshRate;
        this._onDemandFetchRetryDelayMs = onDemandFetchRetryDelayMs;
        this._onDemandFetchMaxRetries = onDemandFetchMaxRetries;
        this._failedAttemptsBeforeLogging = failedAttemptsBeforeLogging;
        this._operationMode = operationMode;
        this._storageMode = storageMode;
        this._validateAfterInactivityInMillis = validateAfterInactivityInMillis;
        this._startingSyncCallBackoffBaseMs = startingSyncCallBackoffBaseMs;
        this._customStorageWrapper = customStorageWrapper;
        this._lastSeenCacheSize = lastSeenCacheSize;
        this._threadFactory = threadFactory;
        this._flagSetsFilter = flagSetsFilter;
        this._invalidSets = invalidSets;
        Properties props = new Properties();
        try {
            props.load(this.getClass().getClassLoader().getResourceAsStream("splitversion.properties"));
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot find client version in classpath", e);
        }
        splitSdkVersion = "undefined";
        if (props.getProperty("sdk.version") != null) {
            splitSdkVersion = "java-" + props.getProperty("sdk.version");
        }
    }

    public String endpoint() {
        return this._endpoint;
    }

    public String eventsEndpoint() {
        return this._eventsEndpoint;
    }

    public int featuresRefreshRate() {
        return this._featuresRefreshRate;
    }

    public int segmentsRefreshRate() {
        return this._segmentsRefreshRate;
    }

    public int numThreadsForSegmentFetch() {
        return this._numThreadsForSegmentFetch;
    }

    public int impressionsRefreshRate() {
        return this._impressionsRefreshRate;
    }

    public int uniqueKeysRefreshRateInMemory() {
        return this._uniqueKeysRefreshRateInMemory;
    }

    public int uniqueKeysRefreshRateRedis() {
        return this._uniqueKeysRefreshRateRedis;
    }

    public static int filterUniqueKeysRefreshRate() {
        return _filterUniqueKeysRefreshRate;
    }

    public int impressionsQueueSize() {
        return this._impressionsQueueSize;
    }

    public ImpressionsManager.Mode impressionsMode() {
        return this._impressionsMode;
    }

    public int metricsRefreshRate() {
        return this._metricsRefreshRate;
    }

    public int connectionTimeout() {
        return this._connectionTimeout;
    }

    public int readTimeout() {
        return this._readTimeout;
    }

    public boolean debugEnabled() {
        return this._debugEnabled;
    }

    public boolean labelsEnabled() {
        return this._labelsEnabled;
    }

    public boolean ipAddressEnabled() {
        return this._ipAddressEnabled;
    }

    public boolean localhostRefreshEnabled() {
        return this._localhostRefreshEnabled;
    }

    public int blockUntilReady() {
        return this._ready;
    }

    public int waitBeforeShutdown() {
        return this._waitBeforeShutdown;
    }

    public HttpHost proxy() {
        return this._proxy;
    }

    public String proxyUsername() {
        return this._proxyUsername;
    }

    public String proxyPassword() {
        return this._proxyPassword;
    }

    public long eventSendIntervalInMillis() {
        return this._eventSendIntervalInMillis;
    }

    public int eventsQueueSize() {
        return this._eventsQueueSize;
    }

    public int maxStringLength() {
        return this._maxStringLength;
    }

    public boolean destroyOnShutDown() {
        return this._destroyOnShutDown;
    }

    public String splitFile() {
        return this._splitFile;
    }

    public FileTypeEnum fileType() {
        return this._fileType;
    }

    public InputStream inputStream() {
        return this._inputStream;
    }

    public String segmentDirectory() {
        return this._segmentDirectory;
    }

    public IntegrationsConfig integrationsConfig() {
        return this._integrationsConfig;
    }

    public boolean streamingEnabled() {
        return this._streamingEnabled;
    }

    public int authRetryBackoffBase() {
        return this._authRetryBackoffBase;
    }

    public int streamingReconnectBackoffBase() {
        return this._streamingReconnectBackoffBase;
    }

    public String authServiceURL() {
        return this._authServiceURL;
    }

    public String streamingServiceURL() {
        return this._streamingServiceURL;
    }

    public String telemetryURL() {
        return this._telemetryURL;
    }

    public int get_telemetryRefreshRate() {
        return this._telemetryRefreshRate;
    }

    public int streamingRetryDelay() {
        return this._onDemandFetchRetryDelayMs;
    }

    public int streamingFetchMaxRetries() {
        return this._onDemandFetchMaxRetries;
    }

    public int failedAttemptsBeforeLogging() {
        return this._failedAttemptsBeforeLogging;
    }

    public OperationMode operationMode() {
        return this._operationMode;
    }

    public long validateAfterInactivityInMillis() {
        return this._validateAfterInactivityInMillis;
    }

    public long startingSyncCallBackoffBaseMs() {
        return this._startingSyncCallBackoffBaseMs;
    }

    public CustomStorageWrapper customStorageWrapper() {
        return this._customStorageWrapper;
    }

    public StorageMode storageMode() {
        return this._storageMode;
    }

    public long getLastSeenCacheSize() {
        return this._lastSeenCacheSize;
    }

    public ThreadFactory getThreadFactory() {
        return this._threadFactory;
    }

    public HashSet<String> getSetsFilter() {
        return this._flagSetsFilter;
    }

    public int getInvalidSets() {
        return this._invalidSets;
    }

    public static final class Builder {
        private String _endpoint = "https://sdk.split.io";
        private boolean _endpointSet = false;
        private String _eventsEndpoint = "https://events.split.io";
        private boolean _eventsEndpointSet = false;
        private int _featuresRefreshRate = 60;
        private int _segmentsRefreshRate = 60;
        private int _impressionsRefreshRate = -1;
        private int _impressionsQueueSize = 30000;
        private ImpressionsManager.Mode _impressionsMode = ImpressionsManager.Mode.OPTIMIZED;
        private int _connectionTimeout = 15000;
        private int _readTimeout = 15000;
        private int _numThreadsForSegmentFetch = 10;
        private boolean _debugEnabled = false;
        private int _ready = -1;
        private int _metricsRefreshRate = 60;
        private boolean _labelsEnabled = true;
        private boolean _ipAddressEnabled = true;
        private boolean _localhostRefreshEnable = false;
        private int _waitBeforeShutdown = 5000;
        private String _proxyHost = "localhost";
        private int _proxyPort = -1;
        private String _proxyUsername;
        private String _proxyPassword;
        private int _eventsQueueSize = 500;
        private long _eventSendIntervalInMillis = 30000L;
        private int _maxStringLength = 250;
        private boolean _destroyOnShutDown = true;
        private String _splitFile = null;
        private FileTypeEnum _fileType = null;
        private InputStream _inputStream = null;
        private String _segmentDirectory = null;
        private IntegrationsConfig _integrationsConfig = null;
        private boolean _streamingEnabled = true;
        private int _authRetryBackoffBase = 1;
        private int _streamingReconnectBackoffBase = 1;
        private String _authServiceURL = "https://auth.split.io/api/v2/auth";
        private String _streamingServiceURL = "https://streaming.split.io/sse";
        private String _telemetryURl = "https://telemetry.split.io/api/v1";
        private int _telemetryRefreshRate = 600;
        private final int _uniqueKeysRefreshRateInMemory = 900;
        private final int _uniqueKeysRefreshRateRedis = 300;
        private final int _filterUniqueKeysRefreshRate = 86400;
        private int _onDemandFetchRetryDelayMs = 50;
        private final int _onDemandFetchMaxRetries = 10;
        private final int _failedAttemptsBeforeLogging = 10;
        private OperationMode _operationMode = OperationMode.STANDALONE;
        private long _validateAfterInactivityInMillis = 1000L;
        private static final long STARTING_SYNC_CALL_BACKOFF_BASE_MS = 1000L;
        private CustomStorageWrapper _customStorageWrapper;
        private StorageMode _storageMode = StorageMode.MEMORY;
        private final long _lastSeenCacheSize = 500000L;
        private ThreadFactory _threadFactory;
        private HashSet<String> _flagSetsFilter = new HashSet();
        private int _invalidSetsCount = 0;

        public Builder numThreadsForSegmentFetch(int numThreadsForSegmentFetch) {
            this._numThreadsForSegmentFetch = numThreadsForSegmentFetch;
            return this;
        }

        public Builder eventsQueueSize(int eventsQueueSize) {
            this._eventsQueueSize = eventsQueueSize;
            return this;
        }

        public Builder eventFlushIntervalInMillis(long eventFlushIntervalInMillis) {
            this._eventSendIntervalInMillis = eventFlushIntervalInMillis;
            return this;
        }

        public Builder endpoint(String endpoint, String eventsEndpoint) {
            this._endpoint = endpoint;
            this._eventsEndpoint = eventsEndpoint;
            return this;
        }

        public Builder featuresRefreshRate(int seconds) {
            this._featuresRefreshRate = seconds;
            return this;
        }

        public Builder segmentsRefreshRate(int seconds) {
            this._segmentsRefreshRate = seconds;
            return this;
        }

        public Builder impressionsRefreshRate(int seconds) {
            this._impressionsRefreshRate = seconds;
            return this;
        }

        public Builder impressionsMode(ImpressionsManager.Mode mode) {
            this._impressionsMode = mode;
            return this;
        }

        public Builder impressionsQueueSize(int impressionsQueueSize) {
            this._impressionsQueueSize = impressionsQueueSize;
            return this;
        }

        @Deprecated
        public Builder impressionListener(ImpressionListener impressionListener, int queueSize) {
            if (null == this._integrationsConfig) {
                this._integrationsConfig = new IntegrationsConfig.Builder().impressionsListener(impressionListener, queueSize).build();
            } else {
                this._integrationsConfig.addStandardImpressionListener(impressionListener, queueSize);
            }
            return this;
        }

        public Builder metricsRefreshRate(int seconds) {
            this._metricsRefreshRate = seconds;
            return this;
        }

        public Builder connectionTimeout(int ms) {
            this._connectionTimeout = ms;
            return this;
        }

        public Builder readTimeout(int ms) {
            this._readTimeout = ms;
            return this;
        }

        public Builder enableDebug() {
            this._debugEnabled = true;
            return this;
        }

        public Builder disableLabels() {
            this._labelsEnabled = false;
            return this;
        }

        public Builder disableIPAddress() {
            this._ipAddressEnabled = false;
            return this;
        }

        public Builder setBlockUntilReadyTimeout(int milliseconds) {
            this._ready = milliseconds;
            return this;
        }

        public Builder waitBeforeShutdown(int waitTime) {
            this._waitBeforeShutdown = waitTime;
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this._proxyHost = proxyHost;
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this._proxyPort = proxyPort;
            return this;
        }

        public Builder proxyUsername(String proxyUsername) {
            this._proxyUsername = proxyUsername;
            return this;
        }

        public Builder proxyPassword(String proxyPassword) {
            this._proxyPassword = proxyPassword;
            return this;
        }

        public Builder disableDestroyOnShutDown() {
            this._destroyOnShutDown = false;
            return this;
        }

        HttpHost proxy() {
            if (this._proxyPort != -1) {
                return new HttpHost(this._proxyHost, this._proxyPort);
            }
            return null;
        }

        public Builder splitFile(String splitFile) {
            this._splitFile = splitFile;
            return this;
        }

        public Builder splitFile(InputStream inputStream, FileTypeEnum fileType) {
            this._fileType = fileType;
            this._inputStream = inputStream;
            return this;
        }

        public Builder segmentDirectory(String sementDirectory) {
            this._segmentDirectory = sementDirectory;
            return this;
        }

        public Builder integrations(IntegrationsConfig config) {
            this._integrationsConfig = config;
            return this;
        }

        public Builder streamingEnabled(boolean streamingEnabled) {
            this._streamingEnabled = streamingEnabled;
            return this;
        }

        public Builder localhostRefreshEnable(boolean localhostRefreshEnable) {
            this._localhostRefreshEnable = localhostRefreshEnable;
            return this;
        }

        public Builder authRetryBackoffBase(int authRetryBackoffBase) {
            this._authRetryBackoffBase = authRetryBackoffBase;
            return this;
        }

        public Builder streamingReconnectBackoffBase(int streamingReconnectBackoffBase) {
            this._streamingReconnectBackoffBase = streamingReconnectBackoffBase;
            return this;
        }

        public Builder authServiceURL(String authServiceURL) {
            this._authServiceURL = authServiceURL;
            return this;
        }

        public Builder streamingServiceURL(String streamingServiceURL) {
            this._streamingServiceURL = streamingServiceURL;
            return this;
        }

        public Builder telemetryURL(String telemetryURL) {
            this._telemetryURl = telemetryURL;
            return this;
        }

        public Builder telemetryRefreshRate(int telemetryRefreshRate) {
            this._telemetryRefreshRate = telemetryRefreshRate;
            return this;
        }

        public Builder operationMode(OperationMode mode) {
            this._operationMode = mode;
            return this;
        }

        public Builder storageMode(StorageMode mode) {
            this._storageMode = mode;
            return this;
        }

        public Builder customStorageWrapper(CustomStorageWrapper customStorageWrapper) {
            this._customStorageWrapper = customStorageWrapper;
            return this;
        }

        public Builder flagSetsFilter(List<String> flagSetsFilter) {
            this._flagSetsFilter = new LinkedHashSet<String>(FlagSetsValidator.cleanup(flagSetsFilter));
            this._invalidSetsCount = flagSetsFilter.size() - this._flagSetsFilter.size();
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this._threadFactory = threadFactory;
            return this;
        }

        public SplitClientConfig build() {
            if (this._featuresRefreshRate < 5) {
                throw new IllegalArgumentException("featuresRefreshRate must be >= 5: " + this._featuresRefreshRate);
            }
            if (this._segmentsRefreshRate < 30) {
                throw new IllegalArgumentException("segmentsRefreshRate must be >= 30: " + this._segmentsRefreshRate);
            }
            switch (this._impressionsMode) {
                case OPTIMIZED: {
                    this._impressionsRefreshRate = this._impressionsRefreshRate <= 0 ? 300 : Math.max(60, this._impressionsRefreshRate);
                    break;
                }
                case DEBUG: {
                    int n = this._impressionsRefreshRate = this._impressionsRefreshRate <= 0 ? 60 : this._impressionsRefreshRate;
                }
            }
            if (this._eventSendIntervalInMillis < 1000L) {
                throw new IllegalArgumentException("_eventSendIntervalInMillis must be >= 1000: " + this._eventSendIntervalInMillis);
            }
            if (this._metricsRefreshRate < 30) {
                throw new IllegalArgumentException("metricsRefreshRate must be >= 30: " + this._metricsRefreshRate);
            }
            if (this._impressionsQueueSize <= 0) {
                throw new IllegalArgumentException("impressionsQueueSize must be > 0: " + this._impressionsQueueSize);
            }
            if (this._connectionTimeout <= 0) {
                throw new IllegalArgumentException("connectionTimeOutInMs must be > 0: " + this._connectionTimeout);
            }
            if (this._readTimeout <= 0) {
                throw new IllegalArgumentException("readTimeout must be > 0: " + this._readTimeout);
            }
            if (this._endpoint == null) {
                throw new IllegalArgumentException("endpoint must not be null");
            }
            if (this._eventsEndpoint == null) {
                throw new IllegalArgumentException("events endpoint must not be null");
            }
            if (this._endpointSet && !this._eventsEndpointSet) {
                throw new IllegalArgumentException("If endpoint is set, you must also set the events endpoint");
            }
            if (this._numThreadsForSegmentFetch <= 0) {
                throw new IllegalArgumentException("Number of threads for fetching segments MUST be greater than zero");
            }
            if (this._authRetryBackoffBase <= 0) {
                throw new IllegalArgumentException("authRetryBackoffBase: must be >= 1");
            }
            if (this._streamingReconnectBackoffBase <= 0) {
                throw new IllegalArgumentException("streamingReconnectBackoffBase: must be >= 1");
            }
            if (this._authServiceURL == null) {
                throw new IllegalArgumentException("authServiceURL must not be null");
            }
            if (this._streamingServiceURL == null) {
                throw new IllegalArgumentException("streamingServiceURL must not be null");
            }
            if (this._telemetryURl == null) {
                throw new IllegalArgumentException("telemetryURl must not be null");
            }
            if (this._onDemandFetchRetryDelayMs <= 0) {
                throw new IllegalStateException("streamingRetryDelay must be > 0");
            }
            if (this._storageMode == null) {
                this._storageMode = StorageMode.MEMORY;
            }
            if (this._telemetryRefreshRate < 60) {
                throw new IllegalStateException("_telemetryRefreshRate must be >= 60");
            }
            if (OperationMode.CONSUMER.equals((Object)this._operationMode)) {
                if (this._customStorageWrapper == null) {
                    throw new IllegalStateException("Custom Storage must not be null on Consumer mode.");
                }
                this._storageMode = StorageMode.PLUGGABLE;
            }
            return new SplitClientConfig(this._endpoint, this._eventsEndpoint, this._featuresRefreshRate, this._segmentsRefreshRate, this._impressionsRefreshRate, this._impressionsQueueSize, this._impressionsMode, this._metricsRefreshRate, this._connectionTimeout, this._readTimeout, this._numThreadsForSegmentFetch, this._ready, this._debugEnabled, this._labelsEnabled, this._ipAddressEnabled, this._localhostRefreshEnable, this._waitBeforeShutdown, this.proxy(), this._proxyUsername, this._proxyPassword, this._eventsQueueSize, this._eventSendIntervalInMillis, this._maxStringLength, this._destroyOnShutDown, this._splitFile, this._fileType, this._inputStream, this._segmentDirectory, this._integrationsConfig, this._streamingEnabled, this._authRetryBackoffBase, this._streamingReconnectBackoffBase, this._authServiceURL, this._streamingServiceURL, this._telemetryURl, this._telemetryRefreshRate, this._onDemandFetchRetryDelayMs, 10, 10, this._operationMode, this._validateAfterInactivityInMillis, 1000L, this._customStorageWrapper, this._storageMode, 900, 300, 86400, 500000L, this._threadFactory, this._flagSetsFilter, this._invalidSetsCount);
        }
    }
}

