/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.memory;

import io.split.engine.segments.SegmentImp;
import io.split.storages.SegmentCache;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.collect.Maps;

public class SegmentCacheInMemoryImpl
implements SegmentCache {
    private static final Logger _log = LoggerFactory.getLogger(SegmentCacheInMemoryImpl.class);
    private static final long DEFAULT_CHANGE_NUMBER = -1L;
    private final ConcurrentMap<String, SegmentImp> _segments = Maps.newConcurrentMap();

    @Override
    public void updateSegment(String segmentName, List<String> toAdd, List<String> toRemove, long changeNumber) {
        this._segments.putIfAbsent(segmentName, new SegmentImp(changeNumber, segmentName, toAdd));
        ((SegmentImp)this._segments.get(segmentName)).update(toAdd, toRemove, changeNumber);
    }

    @Override
    public boolean isInSegment(String segmentName, String key) {
        SegmentImp segmentImp = (SegmentImp)this._segments.get(segmentName);
        if (segmentImp == null) {
            _log.error("Segment " + segmentName + "Not found.");
            return false;
        }
        return segmentImp.contains(key);
    }

    @Override
    public void setChangeNumber(String segmentName, long changeNumber) {
        if (this._segments.get(segmentName) == null) {
            _log.error("Segment " + segmentName + "Not found.");
            return;
        }
        ((SegmentImp)this._segments.get(segmentName)).setChangeNumber(changeNumber);
    }

    @Override
    public long getChangeNumber(String segmentName) {
        SegmentImp segmentImp = (SegmentImp)this._segments.get(segmentName);
        if (segmentImp == null) {
            return -1L;
        }
        return segmentImp.getChangeNumber();
    }

    @VisibleForTesting
    void clear() {
        this._segments.clear();
    }

    @Override
    public long getSegmentCount() {
        return this._segments.values().size();
    }

    @Override
    public long getKeyCount() {
        return this._segments.values().stream().mapToLong(SegmentImp::getKeysSize).sum();
    }
}

