/*
 * Decompiled with CFR 0.152.
 */
package io.split.service;

import io.split.client.dtos.SplitHttpResponse;
import io.split.client.utils.Utils;
import io.split.service.SplitHttpClient;
import io.split.telemetry.domain.enums.HttpParamsWrapper;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.org.apache.hc.core5.http.HttpEntity;

public class HttpPostImp {
    private static final Logger _logger = LoggerFactory.getLogger(HttpPostImp.class);
    private SplitHttpClient _client;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    public HttpPostImp(SplitHttpClient client, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._client = client;
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    public void post(URI uri, Object object, String posted, HttpParamsWrapper httpParamsWrapper) {
        long initTime = System.currentTimeMillis();
        HttpEntity entity = Utils.toJsonEntity(object);
        try {
            SplitHttpResponse response = this._client.post(uri, entity, null);
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                this._telemetryRuntimeProducer.recordSyncError(httpParamsWrapper.getResourceEnum(), response.statusCode());
                return;
            }
            this._telemetryRuntimeProducer.recordSyncLatency(httpParamsWrapper.getHttpLatenciesEnum(), System.currentTimeMillis() - initTime);
            this._telemetryRuntimeProducer.recordSuccessfulSync(httpParamsWrapper.getLastSynchronizationRecordsEnum(), System.currentTimeMillis());
        }
        catch (Throwable t2) {
            _logger.warn("Exception when posting " + posted + object, t2);
        }
    }
}

