/*
 * Decompiled with CFR 0.152.
 */
package io.split.telemetry.storage;

import io.split.telemetry.domain.HTTPErrors;
import io.split.telemetry.domain.HTTPLatencies;
import io.split.telemetry.domain.LastSynchronization;
import io.split.telemetry.domain.MethodExceptions;
import io.split.telemetry.domain.MethodLatencies;
import io.split.telemetry.domain.StreamingEvent;
import io.split.telemetry.domain.UpdatesFromSSE;
import io.split.telemetry.domain.enums.EventsDataRecordsEnum;
import io.split.telemetry.domain.enums.FactoryCountersEnum;
import io.split.telemetry.domain.enums.HTTPLatenciesEnum;
import io.split.telemetry.domain.enums.ImpressionsDataTypeEnum;
import io.split.telemetry.domain.enums.LastSynchronizationRecordsEnum;
import io.split.telemetry.domain.enums.MethodEnum;
import io.split.telemetry.domain.enums.PushCountersEnum;
import io.split.telemetry.domain.enums.ResourceEnum;
import io.split.telemetry.domain.enums.SdkRecordsEnum;
import io.split.telemetry.domain.enums.UpdatesFromSSEEnum;
import io.split.telemetry.storage.TelemetryStorage;
import io.split.telemetry.utils.AtomicLongArray;
import io.split.telemetry.utils.BucketCalculator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import split.com.google.common.collect.Maps;

public class InMemoryTelemetryStorage
implements TelemetryStorage {
    public static final int MAX_LATENCY_BUCKET_COUNT = 23;
    public static final int MAX_STREAMING_EVENTS = 20;
    public static final int MAX_TAGS = 10;
    private final ConcurrentMap<MethodEnum, AtomicLongArray> _methodLatencies = Maps.newConcurrentMap();
    private final ConcurrentMap<HTTPLatenciesEnum, AtomicLongArray> _httpLatencies = Maps.newConcurrentMap();
    private final ConcurrentMap<MethodEnum, AtomicLong> _exceptionsCounters = Maps.newConcurrentMap();
    private final ConcurrentMap<PushCountersEnum, AtomicLong> _pushCounters = Maps.newConcurrentMap();
    private final ConcurrentMap<FactoryCountersEnum, AtomicLong> _factoryCounters = Maps.newConcurrentMap();
    private final ConcurrentMap<ImpressionsDataTypeEnum, AtomicLong> _impressionsDataRecords = Maps.newConcurrentMap();
    private final ConcurrentMap<EventsDataRecordsEnum, AtomicLong> _eventsDataRecords = Maps.newConcurrentMap();
    private final ConcurrentMap<LastSynchronizationRecordsEnum, AtomicLong> _lastSynchronizationRecords = Maps.newConcurrentMap();
    private final ConcurrentMap<SdkRecordsEnum, AtomicLong> _sdkRecords = Maps.newConcurrentMap();
    private final ConcurrentMap<UpdatesFromSSEEnum, AtomicLong> _updatesFromSSERecords = Maps.newConcurrentMap();
    private final ConcurrentMap<ResourceEnum, ConcurrentMap<Long, Long>> _httpErrors = Maps.newConcurrentMap();
    private final Object _streamingEventsLock = new Object();
    private List<StreamingEvent> _streamingEvents = new ArrayList<StreamingEvent>();
    private final Object _tagsLock = new Object();
    private Set<String> _tags = new HashSet<String>();

    public InMemoryTelemetryStorage() {
        this.initMethodLatencies();
        this.initHttpLatencies();
        this.initHttpErrors();
        this.initMethodExceptions();
        this.initFactoryCounters();
        this.initImpressionDataCounters();
        this.initPushCounters();
        this.initSdkRecords();
        this.initLastSynchronizationRecords();
        this.initEventDataRecords();
        this.initUpdatesFromSEE();
    }

    @Override
    public long getBURTimeouts() {
        return ((AtomicLong)this._factoryCounters.get((Object)FactoryCountersEnum.BUR_TIMEOUTS)).get();
    }

    @Override
    public long getNonReadyUsages() {
        return ((AtomicLong)this._factoryCounters.get((Object)FactoryCountersEnum.NON_READY_USAGES)).get();
    }

    @Override
    public MethodExceptions popExceptions() {
        MethodExceptions exceptions = new MethodExceptions();
        exceptions.setTreatment(((AtomicLong)this._exceptionsCounters.get((Object)MethodEnum.TREATMENT)).getAndSet(0L));
        exceptions.setTreatments(((AtomicLong)this._exceptionsCounters.get((Object)MethodEnum.TREATMENTS)).getAndSet(0L));
        exceptions.setTreatmentWithConfig(((AtomicLong)this._exceptionsCounters.get((Object)MethodEnum.TREATMENT_WITH_CONFIG)).getAndSet(0L));
        exceptions.setTreatmentsWithConfig(((AtomicLong)this._exceptionsCounters.get((Object)MethodEnum.TREATMENTS_WITH_CONFIG)).getAndSet(0L));
        exceptions.setTreatmentByFlagSet(((AtomicLong)this._exceptionsCounters.get((Object)MethodEnum.TREATMENTS_BY_FLAG_SET)).getAndSet(0L));
        exceptions.setTreatmentByFlagSets(((AtomicLong)this._exceptionsCounters.get((Object)MethodEnum.TREATMENTS_BY_FLAG_SETS)).getAndSet(0L));
        exceptions.setTreatmentWithConfigByFlagSet(((AtomicLong)this._exceptionsCounters.get((Object)MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SET)).getAndSet(0L));
        exceptions.setTreatmentWithConfigByFlagSets(((AtomicLong)this._exceptionsCounters.get((Object)MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SETS)).getAndSet(0L));
        exceptions.setTrack(((AtomicLong)this._exceptionsCounters.get((Object)MethodEnum.TRACK)).getAndSet(0L));
        return exceptions;
    }

    @Override
    public MethodLatencies popLatencies() {
        MethodLatencies latencies = new MethodLatencies();
        latencies.setTreatment(((AtomicLongArray)this._methodLatencies.get((Object)MethodEnum.TREATMENT)).fetchAndClearAll());
        latencies.setTreatments(((AtomicLongArray)this._methodLatencies.get((Object)MethodEnum.TREATMENTS)).fetchAndClearAll());
        latencies.setTreatmentWithConfig(((AtomicLongArray)this._methodLatencies.get((Object)MethodEnum.TREATMENT_WITH_CONFIG)).fetchAndClearAll());
        latencies.setTreatmentsWithConfig(((AtomicLongArray)this._methodLatencies.get((Object)MethodEnum.TREATMENTS_WITH_CONFIG)).fetchAndClearAll());
        latencies.setTreatmentByFlagSet(((AtomicLongArray)this._methodLatencies.get((Object)MethodEnum.TREATMENTS_BY_FLAG_SET)).fetchAndClearAll());
        latencies.setTreatmentByFlagSets(((AtomicLongArray)this._methodLatencies.get((Object)MethodEnum.TREATMENTS_BY_FLAG_SETS)).fetchAndClearAll());
        latencies.setTreatmentWithConfigByFlagSet(((AtomicLongArray)this._methodLatencies.get((Object)MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SET)).fetchAndClearAll());
        latencies.setTreatmentWithConfigByFlagSets(((AtomicLongArray)this._methodLatencies.get((Object)MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SETS)).fetchAndClearAll());
        latencies.setTrack(((AtomicLongArray)this._methodLatencies.get((Object)MethodEnum.TRACK)).fetchAndClearAll());
        return latencies;
    }

    @Override
    public void recordNonReadyUsage() {
        ((AtomicLong)this._factoryCounters.get((Object)FactoryCountersEnum.NON_READY_USAGES)).incrementAndGet();
    }

    @Override
    public void recordBURTimeout() {
        ((AtomicLong)this._factoryCounters.get((Object)FactoryCountersEnum.BUR_TIMEOUTS)).incrementAndGet();
    }

    @Override
    public void recordLatency(MethodEnum method, long latency) {
        int bucket = BucketCalculator.getBucketForLatency(latency);
        ((AtomicLongArray)this._methodLatencies.get((Object)method)).increment(bucket);
    }

    @Override
    public void recordException(MethodEnum method) {
        ((AtomicLong)this._exceptionsCounters.get((Object)method)).incrementAndGet();
    }

    @Override
    public long getImpressionsStats(ImpressionsDataTypeEnum dataType) {
        return ((AtomicLong)this._impressionsDataRecords.get((Object)dataType)).get();
    }

    @Override
    public long getEventStats(EventsDataRecordsEnum dataType) {
        return ((AtomicLong)this._eventsDataRecords.get((Object)dataType)).get();
    }

    @Override
    public LastSynchronization getLastSynchronization() {
        LastSynchronization lastSynchronization = new LastSynchronization();
        lastSynchronization.setSplits(((AtomicLong)this._lastSynchronizationRecords.get((Object)LastSynchronizationRecordsEnum.SPLITS)).get());
        lastSynchronization.setSegments(((AtomicLong)this._lastSynchronizationRecords.get((Object)LastSynchronizationRecordsEnum.SEGMENTS)).get());
        lastSynchronization.setImpressions(((AtomicLong)this._lastSynchronizationRecords.get((Object)LastSynchronizationRecordsEnum.IMPRESSIONS)).get());
        lastSynchronization.setImpressionsCount(((AtomicLong)this._lastSynchronizationRecords.get((Object)LastSynchronizationRecordsEnum.IMPRESSIONS_COUNT)).get());
        lastSynchronization.setEvents(((AtomicLong)this._lastSynchronizationRecords.get((Object)LastSynchronizationRecordsEnum.EVENTS)).get());
        lastSynchronization.setTelemetry(((AtomicLong)this._lastSynchronizationRecords.get((Object)LastSynchronizationRecordsEnum.TELEMETRY)).get());
        lastSynchronization.setToken(((AtomicLong)this._lastSynchronizationRecords.get((Object)LastSynchronizationRecordsEnum.TOKEN)).get());
        return lastSynchronization;
    }

    @Override
    public HTTPErrors popHTTPErrors() {
        HTTPErrors errors = new HTTPErrors();
        errors.setSplits((Map)this._httpErrors.get((Object)ResourceEnum.SPLIT_SYNC));
        errors.setSegments((Map)this._httpErrors.get((Object)ResourceEnum.SEGMENT_SYNC));
        errors.setImpressions((Map)this._httpErrors.get((Object)ResourceEnum.IMPRESSION_SYNC));
        errors.setImpressionsCount((Map)this._httpErrors.get((Object)ResourceEnum.IMPRESSION_COUNT_SYNC));
        errors.setEvents((Map)this._httpErrors.get((Object)ResourceEnum.EVENT_SYNC));
        errors.setTelemetry((Map)this._httpErrors.get((Object)ResourceEnum.TELEMETRY_SYNC));
        errors.setToken((Map)this._httpErrors.get((Object)ResourceEnum.TOKEN_SYNC));
        this._httpErrors.clear();
        this.initHttpErrors();
        return errors;
    }

    @Override
    public HTTPLatencies popHTTPLatencies() {
        HTTPLatencies latencies = new HTTPLatencies();
        latencies.setSplits(((AtomicLongArray)this._httpLatencies.get((Object)HTTPLatenciesEnum.SPLITS)).fetchAndClearAll());
        latencies.setSegments(((AtomicLongArray)this._httpLatencies.get((Object)HTTPLatenciesEnum.SEGMENTS)).fetchAndClearAll());
        latencies.setImpressions(((AtomicLongArray)this._httpLatencies.get((Object)HTTPLatenciesEnum.IMPRESSIONS)).fetchAndClearAll());
        latencies.setImpressionsCount(((AtomicLongArray)this._httpLatencies.get((Object)HTTPLatenciesEnum.IMPRESSIONS_COUNT)).fetchAndClearAll());
        latencies.setEvents(((AtomicLongArray)this._httpLatencies.get((Object)HTTPLatenciesEnum.EVENTS)).fetchAndClearAll());
        latencies.setTelemetry(((AtomicLongArray)this._httpLatencies.get((Object)HTTPLatenciesEnum.TELEMETRY)).fetchAndClearAll());
        latencies.setToken(((AtomicLongArray)this._httpLatencies.get((Object)HTTPLatenciesEnum.TOKEN)).fetchAndClearAll());
        return latencies;
    }

    @Override
    public long popAuthRejections() {
        long authRejections = ((AtomicLong)this._pushCounters.get((Object)PushCountersEnum.AUTH_REJECTIONS)).get();
        this._pushCounters.replace(PushCountersEnum.AUTH_REJECTIONS, new AtomicLong());
        return authRejections;
    }

    @Override
    public long popTokenRefreshes() {
        long tokenRefreshes = ((AtomicLong)this._pushCounters.get((Object)PushCountersEnum.TOKEN_REFRESHES)).get();
        this._pushCounters.replace(PushCountersEnum.TOKEN_REFRESHES, new AtomicLong());
        return tokenRefreshes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StreamingEvent> popStreamingEvents() {
        Object object = this._streamingEventsLock;
        synchronized (object) {
            List<StreamingEvent> streamingEvents = this._streamingEvents;
            this._streamingEvents = new ArrayList<StreamingEvent>();
            return streamingEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> popTags() {
        Object object = this._tagsLock;
        synchronized (object) {
            ArrayList<String> tags = new ArrayList<String>(this._tags);
            this._tags = new HashSet<String>();
            return tags;
        }
    }

    @Override
    public long getSessionLength() {
        return ((AtomicLong)this._sdkRecords.get((Object)SdkRecordsEnum.SESSION)).get();
    }

    @Override
    public UpdatesFromSSE popUpdatesFromSSE() {
        UpdatesFromSSE updatesFromSSE = new UpdatesFromSSE();
        updatesFromSSE.setSplits(((AtomicLong)this._updatesFromSSERecords.get((Object)UpdatesFromSSEEnum.SPLITS)).getAndSet(0L));
        return updatesFromSSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTag(String tag) {
        Object object = this._tagsLock;
        synchronized (object) {
            if (this._tags.size() < 10) {
                this._tags.add(tag);
            }
        }
    }

    @Override
    public void recordImpressionStats(ImpressionsDataTypeEnum dataType, long count) {
        ((AtomicLong)this._impressionsDataRecords.get((Object)dataType)).addAndGet(count);
    }

    @Override
    public void recordEventStats(EventsDataRecordsEnum dataType, long count) {
        ((AtomicLong)this._eventsDataRecords.get((Object)dataType)).addAndGet(count);
    }

    @Override
    public void recordSuccessfulSync(LastSynchronizationRecordsEnum resource, long time) {
        this._lastSynchronizationRecords.replace(resource, new AtomicLong(time));
    }

    @Override
    public void recordSyncError(ResourceEnum resource, int status) {
        ConcurrentMap errors = (ConcurrentMap)this._httpErrors.get((Object)resource);
        errors.putIfAbsent(Long.valueOf(status), 0L);
        errors.replace(Long.valueOf(status), (Long)errors.get(status) + 1L);
    }

    @Override
    public void recordSyncLatency(HTTPLatenciesEnum resource, long latency) {
        int bucket = BucketCalculator.getBucketForLatency(latency);
        ((AtomicLongArray)this._httpLatencies.get((Object)resource)).increment(bucket);
    }

    @Override
    public void recordAuthRejections() {
        ((AtomicLong)this._pushCounters.get((Object)PushCountersEnum.AUTH_REJECTIONS)).incrementAndGet();
    }

    @Override
    public void recordTokenRefreshes() {
        ((AtomicLong)this._pushCounters.get((Object)PushCountersEnum.TOKEN_REFRESHES)).incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordStreamingEvents(StreamingEvent streamingEvent) {
        Object object = this._streamingEventsLock;
        synchronized (object) {
            if (this._streamingEvents.size() < 20) {
                this._streamingEvents.add(streamingEvent);
            }
        }
    }

    @Override
    public void recordSessionLength(long sessionLength) {
        this._sdkRecords.replace(SdkRecordsEnum.SESSION, new AtomicLong(sessionLength));
    }

    @Override
    public void recordUpdatesFromSSE(UpdatesFromSSEEnum updatesFromSSEEnum) {
        ((AtomicLong)this._updatesFromSSERecords.get((Object)UpdatesFromSSEEnum.SPLITS)).incrementAndGet();
    }

    private void initMethodLatencies() {
        this._methodLatencies.put(MethodEnum.TREATMENT, new AtomicLongArray(23));
        this._methodLatencies.put(MethodEnum.TREATMENTS, new AtomicLongArray(23));
        this._methodLatencies.put(MethodEnum.TREATMENT_WITH_CONFIG, new AtomicLongArray(23));
        this._methodLatencies.put(MethodEnum.TREATMENTS_WITH_CONFIG, new AtomicLongArray(23));
        this._methodLatencies.put(MethodEnum.TREATMENTS_BY_FLAG_SET, new AtomicLongArray(23));
        this._methodLatencies.put(MethodEnum.TREATMENTS_BY_FLAG_SETS, new AtomicLongArray(23));
        this._methodLatencies.put(MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SET, new AtomicLongArray(23));
        this._methodLatencies.put(MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SETS, new AtomicLongArray(23));
        this._methodLatencies.put(MethodEnum.TRACK, new AtomicLongArray(23));
    }

    private void initHttpLatencies() {
        this._httpLatencies.put(HTTPLatenciesEnum.SPLITS, new AtomicLongArray(23));
        this._httpLatencies.put(HTTPLatenciesEnum.SEGMENTS, new AtomicLongArray(23));
        this._httpLatencies.put(HTTPLatenciesEnum.IMPRESSIONS, new AtomicLongArray(23));
        this._httpLatencies.put(HTTPLatenciesEnum.IMPRESSIONS_COUNT, new AtomicLongArray(23));
        this._httpLatencies.put(HTTPLatenciesEnum.EVENTS, new AtomicLongArray(23));
        this._httpLatencies.put(HTTPLatenciesEnum.TELEMETRY, new AtomicLongArray(23));
        this._httpLatencies.put(HTTPLatenciesEnum.TOKEN, new AtomicLongArray(23));
    }

    private void initHttpErrors() {
        this._httpErrors.put(ResourceEnum.SPLIT_SYNC, Maps.newConcurrentMap());
        this._httpErrors.put(ResourceEnum.SEGMENT_SYNC, Maps.newConcurrentMap());
        this._httpErrors.put(ResourceEnum.IMPRESSION_SYNC, Maps.newConcurrentMap());
        this._httpErrors.put(ResourceEnum.IMPRESSION_COUNT_SYNC, Maps.newConcurrentMap());
        this._httpErrors.put(ResourceEnum.EVENT_SYNC, Maps.newConcurrentMap());
        this._httpErrors.put(ResourceEnum.TELEMETRY_SYNC, Maps.newConcurrentMap());
        this._httpErrors.put(ResourceEnum.TOKEN_SYNC, Maps.newConcurrentMap());
    }

    private void initMethodExceptions() {
        this._exceptionsCounters.put(MethodEnum.TREATMENT, new AtomicLong());
        this._exceptionsCounters.put(MethodEnum.TREATMENTS, new AtomicLong());
        this._exceptionsCounters.put(MethodEnum.TREATMENT_WITH_CONFIG, new AtomicLong());
        this._exceptionsCounters.put(MethodEnum.TREATMENTS_WITH_CONFIG, new AtomicLong());
        this._exceptionsCounters.put(MethodEnum.TREATMENTS_BY_FLAG_SET, new AtomicLong());
        this._exceptionsCounters.put(MethodEnum.TREATMENTS_BY_FLAG_SETS, new AtomicLong());
        this._exceptionsCounters.put(MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SET, new AtomicLong());
        this._exceptionsCounters.put(MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SETS, new AtomicLong());
        this._exceptionsCounters.put(MethodEnum.TRACK, new AtomicLong());
    }

    private void initFactoryCounters() {
        this._factoryCounters.put(FactoryCountersEnum.BUR_TIMEOUTS, new AtomicLong());
        this._factoryCounters.put(FactoryCountersEnum.NON_READY_USAGES, new AtomicLong());
    }

    private void initImpressionDataCounters() {
        this._impressionsDataRecords.put(ImpressionsDataTypeEnum.IMPRESSIONS_DEDUPED, new AtomicLong());
        this._impressionsDataRecords.put(ImpressionsDataTypeEnum.IMPRESSIONS_DROPPED, new AtomicLong());
        this._impressionsDataRecords.put(ImpressionsDataTypeEnum.IMPRESSIONS_QUEUED, new AtomicLong());
    }

    private void initPushCounters() {
        this._pushCounters.put(PushCountersEnum.AUTH_REJECTIONS, new AtomicLong());
        this._pushCounters.put(PushCountersEnum.TOKEN_REFRESHES, new AtomicLong());
    }

    private void initSdkRecords() {
        this._sdkRecords.put(SdkRecordsEnum.SESSION, new AtomicLong());
    }

    private void initLastSynchronizationRecords() {
        this._lastSynchronizationRecords.put(LastSynchronizationRecordsEnum.SPLITS, new AtomicLong());
        this._lastSynchronizationRecords.put(LastSynchronizationRecordsEnum.SEGMENTS, new AtomicLong());
        this._lastSynchronizationRecords.put(LastSynchronizationRecordsEnum.EVENTS, new AtomicLong());
        this._lastSynchronizationRecords.put(LastSynchronizationRecordsEnum.IMPRESSIONS, new AtomicLong());
        this._lastSynchronizationRecords.put(LastSynchronizationRecordsEnum.IMPRESSIONS_COUNT, new AtomicLong());
        this._lastSynchronizationRecords.put(LastSynchronizationRecordsEnum.TOKEN, new AtomicLong());
        this._lastSynchronizationRecords.put(LastSynchronizationRecordsEnum.TELEMETRY, new AtomicLong());
    }

    private void initEventDataRecords() {
        this._eventsDataRecords.put(EventsDataRecordsEnum.EVENTS_DROPPED, new AtomicLong());
        this._eventsDataRecords.put(EventsDataRecordsEnum.EVENTS_QUEUED, new AtomicLong());
    }

    private void initUpdatesFromSEE() {
        this._updatesFromSSERecords.put(UpdatesFromSSEEnum.SPLITS, new AtomicLong());
    }
}

