/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.engine.evaluator.EvaluationContext;
import io.split.engine.matchers.Matcher;
import io.split.engine.matchers.Semver;
import java.util.Map;

public class BetweenSemverMatcher
implements Matcher {
    private final Semver _semverStart;
    private final Semver _semverEnd;

    public BetweenSemverMatcher(String semverStart, String semverEnd) {
        this._semverStart = Semver.build(semverStart);
        this._semverEnd = Semver.build(semverEnd);
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, EvaluationContext evaluationContext) {
        if (!(matchValue instanceof String) || this._semverStart == null || this._semverEnd == null) {
            return false;
        }
        Semver matchSemver = Semver.build(matchValue.toString());
        if (matchSemver == null) {
            return false;
        }
        return matchSemver.compare(this._semverStart) >= 0 && matchSemver.compare(this._semverEnd) <= 0;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("between semver ");
        bldr.append(this._semverStart.version());
        bldr.append(" and ");
        bldr.append(this._semverEnd.version());
        return bldr.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._semverStart.hashCode() + this._semverEnd.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BetweenSemverMatcher)) {
            return false;
        }
        BetweenSemverMatcher other = (BetweenSemverMatcher)obj;
        return this._semverStart == other._semverStart && this._semverEnd == other._semverEnd;
    }
}

