/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.SplitChange;
import io.split.client.utils.InputStreamProvider;
import io.split.client.utils.Json;
import io.split.client.utils.LocalhostSanitizer;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.SplitChangeFetcher;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.gson.stream.JsonReader;

public class JsonLocalhostSplitChangeFetcher
implements SplitChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(JsonLocalhostSplitChangeFetcher.class);
    private final InputStreamProvider _inputStreamProvider;
    private byte[] lastHash;

    public JsonLocalhostSplitChangeFetcher(InputStreamProvider inputStreamProvider) {
        this._inputStreamProvider = inputStreamProvider;
        this.lastHash = new byte[0];
    }

    @Override
    public SplitChange fetch(long since, FetchOptions options) {
        try {
            JsonReader jsonReader = new JsonReader(new BufferedReader(new InputStreamReader(this._inputStreamProvider.get(), StandardCharsets.UTF_8)));
            SplitChange splitChange = Json.fromJson(jsonReader, SplitChange.class);
            return this.processSplitChange(splitChange, since);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem fetching splitChanges: " + e.getMessage(), e);
        }
    }

    private SplitChange processSplitChange(SplitChange splitChange, long changeNumber) throws NoSuchAlgorithmException {
        SplitChange splitChangeToProcess = LocalhostSanitizer.sanitization(splitChange);
        if (splitChangeToProcess.till < changeNumber && splitChangeToProcess.till != -1L) {
            _log.warn("The till is lower than the change number or different to -1");
            return null;
        }
        String splitJson = splitChange.splits.toString();
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.reset();
        digest.update(splitJson.getBytes());
        byte[] currHash = digest.digest();
        if (MessageDigest.isEqual(this.lastHash, currHash) || splitChangeToProcess.till == -1L) {
            splitChangeToProcess.till = changeNumber;
        }
        this.lastHash = currHash;
        splitChangeToProcess.since = changeNumber;
        return splitChangeToProcess;
    }
}

