/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.dtos.TestImpressions;
import io.split.client.impressions.ImpressionCounter;
import io.split.client.impressions.ImpressionsSender;
import io.split.storages.pluggable.domain.PrefixAdapter;
import io.split.storages.pluggable.domain.UserPipelineWrapper;
import io.split.storages.pluggable.domain.UserStorageWrapper;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluggable.CustomStorageWrapper;
import split.com.google.common.base.Preconditions;

public class PluggableImpressionSender
implements ImpressionsSender {
    private final UserStorageWrapper _userStorageWrapper;
    private static final Logger _logger = LoggerFactory.getLogger(PluggableImpressionSender.class);

    public static PluggableImpressionSender create(CustomStorageWrapper customStorageWrapper) {
        return new PluggableImpressionSender(customStorageWrapper);
    }

    private PluggableImpressionSender(CustomStorageWrapper customStorageWrapper) {
        this._userStorageWrapper = new UserStorageWrapper(Preconditions.checkNotNull(customStorageWrapper));
    }

    @Override
    public void postImpressionsBulk(List<TestImpressions> impressions) {
    }

    @Override
    public void postCounters(HashMap<ImpressionCounter.Key, Integer> counts) {
        try {
            UserPipelineWrapper pipelineExecution = this._userStorageWrapper.pipeline();
            for (ImpressionCounter.Key countsKey : counts.keySet()) {
                String key = PrefixAdapter.buildImpressionsCount();
                pipelineExecution.hIncrement(key, countsKey.featureName() + "::" + countsKey.timeFrame(), counts.get(countsKey).intValue());
            }
            pipelineExecution.exec();
        }
        catch (Exception e) {
            _logger.warn("Redis pipeline exception when posting counters: ", (Throwable)e);
        }
    }
}

