/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions.strategy;

import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionCounter;
import io.split.client.impressions.ImpressionObserver;
import io.split.client.impressions.ImpressionUtils;
import io.split.client.impressions.ImpressionsResult;
import io.split.client.impressions.strategy.ProcessImpressionStrategy;
import io.split.telemetry.domain.enums.ImpressionsDataTypeEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ProcessImpressionOptimized
implements ProcessImpressionStrategy {
    private final ImpressionObserver _impressionObserver;
    private final ImpressionCounter _impressionCounter;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;
    private final boolean _listenerEnabled;

    public ProcessImpressionOptimized(boolean listenerEnabled, ImpressionObserver impressionObserver, ImpressionCounter impressionCounter, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._telemetryRuntimeProducer = telemetryRuntimeProducer;
        this._listenerEnabled = listenerEnabled;
        this._impressionObserver = impressionObserver;
        this._impressionCounter = impressionCounter;
    }

    @Override
    public ImpressionsResult process(List<Impression> impressions) {
        ArrayList<Impression> impressionsToQueue = new ArrayList<Impression>();
        for (Impression impression : impressions) {
            if (impression.properties() == null) {
                if (!Objects.isNull((impression = impression.withPreviousTime(this._impressionObserver.testAndSet(impression))).pt()) && impression.pt() != 0L) {
                    this._impressionCounter.inc(impression.split(), impression.time(), 1);
                }
                if (this.shouldntQueueImpression(impression)) continue;
            }
            impressionsToQueue.add(impression);
        }
        List<Impression> impressionForListener = this._listenerEnabled ? impressions : null;
        this._telemetryRuntimeProducer.recordImpressionStats(ImpressionsDataTypeEnum.IMPRESSIONS_DEDUPED, (long)impressions.size() - (long)impressionsToQueue.size());
        return new ImpressionsResult(impressionsToQueue, impressionForListener);
    }

    private boolean shouldntQueueImpression(Impression i) {
        return !Objects.isNull(i.pt()) && ImpressionUtils.truncateTimeframe(i.pt()) == ImpressionUtils.truncateTimeframe(i.time());
    }
}

