/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import io.split.client.dtos.Condition;
import io.split.client.dtos.RuleBasedSegment;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedRuleBasedSegment;
import io.split.engine.experiments.ParserUtils;
import io.split.engine.matchers.CombiningMatcher;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.collect.Lists;

public final class RuleBasedSegmentParser {
    private static final Logger _log = LoggerFactory.getLogger(RuleBasedSegmentParser.class);

    public ParsedRuleBasedSegment parse(RuleBasedSegment ruleBasedSegment) {
        try {
            return this.parseWithoutExceptionHandling(ruleBasedSegment);
        }
        catch (Throwable t2) {
            _log.error("Could not parse rule based segment: " + ruleBasedSegment, t2);
            return null;
        }
    }

    private ParsedRuleBasedSegment parseWithoutExceptionHandling(RuleBasedSegment ruleBasedSegment) {
        ArrayList<ParsedCondition> parsedConditionList = Lists.newArrayList();
        for (Condition condition : ruleBasedSegment.conditions) {
            if (ParserUtils.checkUnsupportedMatcherExist(condition.matcherGroup.matchers)) {
                _log.error("Unsupported matcher type found for rule based segment: " + ruleBasedSegment.name + " , will revert to default template matcher.");
                parsedConditionList.clear();
                parsedConditionList.add(ParserUtils.getTemplateCondition());
                break;
            }
            CombiningMatcher matcher = ParserUtils.toMatcher(condition.matcherGroup);
            parsedConditionList.add(new ParsedCondition(condition.conditionType, matcher, null, condition.label));
        }
        return new ParsedRuleBasedSegment(ruleBasedSegment.name, parsedConditionList, ruleBasedSegment.trafficTypeName, ruleBasedSegment.changeNumber, ruleBasedSegment.excluded.keys, ruleBasedSegment.excluded.segments);
    }
}

