/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.SegmentChange;
import io.split.client.dtos.SplitHttpResponse;
import io.split.client.utils.Json;
import io.split.client.utils.Utils;
import io.split.engine.common.FetchOptions;
import io.split.engine.segments.SegmentChangeFetcher;
import io.split.service.SplitHttpClient;
import io.split.telemetry.domain.enums.HTTPLatenciesEnum;
import io.split.telemetry.domain.enums.LastSynchronizationRecordsEnum;
import io.split.telemetry.domain.enums.ResourceEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.org.apache.hc.core5.net.URIBuilder;

public final class HttpSegmentChangeFetcher
implements SegmentChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSegmentChangeFetcher.class);
    private static final String SINCE = "since";
    private static final String TILL = "till";
    private final SplitHttpClient _client;
    private final URI _target;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    public static HttpSegmentChangeFetcher create(SplitHttpClient client, URI root, TelemetryRuntimeProducer telemetryRuntimeProducer) throws URISyntaxException {
        return new HttpSegmentChangeFetcher(client, Utils.appendPath(root, "api/segmentChanges"), telemetryRuntimeProducer);
    }

    private HttpSegmentChangeFetcher(SplitHttpClient client, URI uri, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._client = client;
        this._target = uri;
        Preconditions.checkNotNull(this._target);
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    @Override
    public SegmentChange fetch(String segmentName, long since, FetchOptions options) {
        long start = System.currentTimeMillis();
        try {
            URI uri;
            SplitHttpResponse response;
            String path = this._target.getPath() + "/" + segmentName;
            URIBuilder uriBuilder = new URIBuilder(this._target).setPath(path).addParameter(SINCE, "" + since);
            if (options.hasCustomCN()) {
                uriBuilder.addParameter(TILL, "" + options.targetCN());
            }
            if ((response = this._client.get(uri = uriBuilder.build(), options, null)).statusCode() < 200 || response.statusCode() >= 300) {
                this._telemetryRuntimeProducer.recordSyncError(ResourceEnum.SEGMENT_SYNC, response.statusCode());
                if (response.statusCode() == 403) {
                    _log.error("factory instantiation: you passed a client side type sdkKey, please grab an sdk key from the Split user interface that is of type server side");
                }
                throw new IllegalStateException(String.format("Could not retrieve segment changes for %s, since %s; http return code %s", segmentName, since, response.statusCode()));
            }
            this._telemetryRuntimeProducer.recordSuccessfulSync(LastSynchronizationRecordsEnum.SEGMENTS, System.currentTimeMillis());
            SegmentChange segmentChange = Json.fromJson(response.body(), SegmentChange.class);
            return segmentChange;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error occurred when trying to sync segment: %s, since: %s. Details: %s", segmentName, since, e), e);
        }
        finally {
            this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.SEGMENTS, System.currentTimeMillis() - start);
        }
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }
}

