/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.SplitChange;
import io.split.client.dtos.SplitChangesOldPayloadDto;
import io.split.client.dtos.SplitHttpResponse;
import io.split.client.exceptions.UriTooLongException;
import io.split.client.utils.Json;
import io.split.client.utils.Utils;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.service.SplitHttpClient;
import io.split.telemetry.domain.enums.HTTPLatenciesEnum;
import io.split.telemetry.domain.enums.ResourceEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.org.apache.hc.core5.net.URIBuilder;

public final class HttpSplitChangeFetcher
implements SplitChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSplitChangeFetcher.class);
    private static final String SINCE = "since";
    private static final String RB_SINCE = "rbSince";
    private static final String TILL = "till";
    private static final String SETS = "sets";
    private static final String SPEC = "s";
    private String specVersion = "1.3";
    private int PROXY_CHECK_INTERVAL_MILLISECONDS_SS = 86400000;
    private Long _lastProxyCheckTimestamp = 0L;
    private final SplitHttpClient _client;
    private final URI _target;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;
    private final boolean _rootURIOverriden;

    public static HttpSplitChangeFetcher create(SplitHttpClient client, URI root, TelemetryRuntimeProducer telemetryRuntimeProducer, boolean rootURIOverriden) throws URISyntaxException {
        return new HttpSplitChangeFetcher(client, Utils.appendPath(root, "api/splitChanges"), telemetryRuntimeProducer, rootURIOverriden);
    }

    private HttpSplitChangeFetcher(SplitHttpClient client, URI uri, TelemetryRuntimeProducer telemetryRuntimeProducer, boolean rootURIOverriden) {
        this._client = client;
        this._target = uri;
        Preconditions.checkNotNull(this._target);
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
        this._rootURIOverriden = rootURIOverriden;
    }

    long makeRandomTill() {
        return -1L * (long)Math.floor(Math.random() * Math.pow(2.0, 63.0));
    }

    @Override
    public SplitChange fetch(long since, long sinceRBS, FetchOptions options) {
        long start = System.currentTimeMillis();
        try {
            SplitHttpResponse response;
            URI uri = this.buildURL(options, since, sinceRBS);
            if (this.specVersion.equals("1.1") && System.currentTimeMillis() - this._lastProxyCheckTimestamp >= (long)this.PROXY_CHECK_INTERVAL_MILLISECONDS_SS) {
                _log.info("Switching to new Feature flag spec ({}) and fetching.", (Object)"1.3");
                this.specVersion = "1.3";
                uri = this.buildURL(options, -1L, -1L);
            }
            if ((response = this._client.get(uri, options, null)).statusCode() < 200 || response.statusCode() >= 300) {
                if (response.statusCode() == 414) {
                    _log.error("The amount of flag sets provided are big causing uri length error.");
                    throw new UriTooLongException(String.format("Status code: %s. Message: %s", response.statusCode(), response.statusMessage()));
                }
                if (response.statusCode() == 400 && this.specVersion.equals("1.3") && this._rootURIOverriden) {
                    this.specVersion = "1.1";
                    _log.warn("Detected proxy without support for Feature flags spec {} version, will switch to spec version {}", (Object)"1.3", (Object)"1.1");
                    this._lastProxyCheckTimestamp = System.currentTimeMillis();
                    SplitChange splitChange = this.fetch(since, sinceRBS, options);
                    return splitChange;
                }
                this._telemetryRuntimeProducer.recordSyncError(ResourceEnum.SPLIT_SYNC, response.statusCode());
                throw new IllegalStateException(String.format("Could not retrieve splitChanges since %s; http return code %s", since, response.statusCode()));
            }
            if (this.specVersion.equals("1.1")) {
                SplitChange splitChange = Json.fromJson(response.body(), SplitChangesOldPayloadDto.class).toSplitChange();
                return splitChange;
            }
            SplitChange splitChange = Json.fromJson(response.body(), SplitChange.class);
            splitChange.clearCache = this._lastProxyCheckTimestamp != 0L;
            this._lastProxyCheckTimestamp = 0L;
            SplitChange splitChange2 = splitChange;
            return splitChange2;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Problem fetching splitChanges since %s: %s", since, e), e);
        }
        finally {
            this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.SPLITS, System.currentTimeMillis() - start);
        }
    }

    private URI buildURL(FetchOptions options, long since, long sinceRBS) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this._target).addParameter(SPEC, "" + this.specVersion);
        uriBuilder.addParameter(SINCE, "" + since);
        if (this.specVersion.equals("1.3")) {
            uriBuilder.addParameter(RB_SINCE, "" + sinceRBS);
        }
        if (!options.flagSetsFilter().isEmpty()) {
            uriBuilder.addParameter(SETS, "" + options.flagSetsFilter());
        }
        if (options.hasCustomCN()) {
            uriBuilder.addParameter(TILL, "" + options.targetCN());
        }
        return uriBuilder.build();
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }
}

