/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitFactory;
import io.split.client.api.Key;
import io.split.client.api.SplitResult;
import io.split.client.dtos.DecoratedImpression;
import io.split.client.dtos.EvaluationOptions;
import io.split.client.dtos.Event;
import io.split.client.events.EventsStorageProducer;
import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.interceptors.FlagSetsFilter;
import io.split.engine.SDKReadinessGates;
import io.split.engine.evaluator.Evaluator;
import io.split.engine.evaluator.EvaluatorImp;
import io.split.inputValidation.EventsValidator;
import io.split.inputValidation.FlagSetsValidator;
import io.split.inputValidation.ImpressionPropertiesValidator;
import io.split.inputValidation.KeyValidator;
import io.split.inputValidation.SplitNameValidator;
import io.split.inputValidation.TrafficTypeValidator;
import io.split.storages.SplitCacheConsumer;
import io.split.telemetry.domain.enums.MethodEnum;
import io.split.telemetry.storage.TelemetryConfigProducer;
import io.split.telemetry.storage.TelemetryEvaluationProducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.gson.GsonBuilder;

public final class SplitClientImpl
implements SplitClient {
    public static final SplitResult SPLIT_RESULT_CONTROL = new SplitResult("control", null);
    private static final String CLIENT_DESTROY = "Client has already been destroyed - no calls possible";
    private static final String CATCHALL_EXCEPTION = "CatchAll Exception";
    private static final String MATCHING_KEY = "matchingKey";
    private static final Logger _log = LoggerFactory.getLogger(SplitClientImpl.class);
    private final SplitFactory _container;
    private final SplitCacheConsumer _splitCacheConsumer;
    private final ImpressionsManager _impressionManager;
    private final SplitClientConfig _config;
    private final EventsStorageProducer _eventsStorageProducer;
    private final SDKReadinessGates _gates;
    private final Evaluator _evaluator;
    private final TelemetryEvaluationProducer _telemetryEvaluationProducer;
    private final TelemetryConfigProducer _telemetryConfigProducer;
    private final FlagSetsFilter _flagSetsFilter;

    public SplitClientImpl(SplitFactory container, SplitCacheConsumer splitCacheConsumer, ImpressionsManager impressionManager, EventsStorageProducer eventsStorageProducer, SplitClientConfig config, SDKReadinessGates gates, Evaluator evaluator, TelemetryEvaluationProducer telemetryEvaluationProducer, TelemetryConfigProducer telemetryConfigProducer, FlagSetsFilter flagSetsFilter) {
        this._container = container;
        this._splitCacheConsumer = Preconditions.checkNotNull(splitCacheConsumer);
        this._impressionManager = Preconditions.checkNotNull(impressionManager);
        this._eventsStorageProducer = eventsStorageProducer;
        this._config = config;
        this._gates = Preconditions.checkNotNull(gates);
        this._evaluator = Preconditions.checkNotNull(evaluator);
        this._telemetryEvaluationProducer = Preconditions.checkNotNull(telemetryEvaluationProducer);
        this._telemetryConfigProducer = Preconditions.checkNotNull(telemetryConfigProducer);
        this._flagSetsFilter = flagSetsFilter;
    }

    @Override
    public String getTreatment(String key, String featureFlagName) {
        return this.getTreatment(key, featureFlagName, Collections.emptyMap());
    }

    @Override
    public String getTreatment(String key, String featureFlagName, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(key, null, featureFlagName, attributes, new EvaluationOptions(null), MethodEnum.TREATMENT).treatment();
    }

    @Override
    public String getTreatment(Key key, String featureFlagName, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(key.matchingKey(), key.bucketingKey(), featureFlagName, attributes, new EvaluationOptions(null), MethodEnum.TREATMENT).treatment();
    }

    @Override
    public SplitResult getTreatmentWithConfig(String key, String featureFlagName) {
        return this.getTreatmentWithConfigInternal(key, null, featureFlagName, Collections.emptyMap(), new EvaluationOptions(null), MethodEnum.TREATMENT_WITH_CONFIG);
    }

    @Override
    public SplitResult getTreatmentWithConfig(String key, String featureFlagName, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(key, null, featureFlagName, attributes, new EvaluationOptions(null), MethodEnum.TREATMENT_WITH_CONFIG);
    }

    @Override
    public SplitResult getTreatmentWithConfig(Key key, String featureFlagName, Map<String, Object> attributes) {
        return this.getTreatmentWithConfigInternal(key.matchingKey(), key.bucketingKey(), featureFlagName, attributes, new EvaluationOptions(null), MethodEnum.TREATMENT_WITH_CONFIG);
    }

    @Override
    public Map<String, String> getTreatments(String key, List<String> featureFlagNames) {
        return this.getTreatments(key, featureFlagNames, Collections.emptyMap());
    }

    @Override
    public Map<String, String> getTreatments(String key, List<String> featureFlagNames, Map<String, Object> attributes) {
        return this.getTreatmentsWithConfigInternal(key, null, featureFlagNames, attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, String> getTreatments(Key key, List<String> featureFlagNames, Map<String, Object> attributes) {
        return this.getTreatmentsWithConfigInternal(key.matchingKey(), key.bucketingKey(), featureFlagNames, attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfig(String key, List<String> featureFlagNames) {
        return this.getTreatmentsWithConfigInternal(key, null, featureFlagNames, Collections.emptyMap(), new EvaluationOptions(null), MethodEnum.TREATMENTS_WITH_CONFIG);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfig(String key, List<String> featureFlagNames, Map<String, Object> attributes) {
        return this.getTreatmentsWithConfigInternal(key, null, featureFlagNames, attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS_WITH_CONFIG);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfig(Key key, List<String> featureFlagNames, Map<String, Object> attributes) {
        return this.getTreatmentsWithConfigInternal(key.matchingKey(), key.bucketingKey(), featureFlagNames, attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS_WITH_CONFIG);
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSet(String key, String flagSet) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, new ArrayList<String>(Arrays.asList(flagSet)), null, new EvaluationOptions(null), MethodEnum.TREATMENTS_BY_FLAG_SET).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSet(String key, String flagSet, Map<String, Object> attributes) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, new ArrayList<String>(Arrays.asList(flagSet)), attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS_BY_FLAG_SET).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSet(Key key, String flagSet, Map<String, Object> attributes) {
        return this.getTreatmentsBySetsWithConfigInternal(key.matchingKey(), key.bucketingKey(), new ArrayList<String>(Arrays.asList(flagSet)), attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS_BY_FLAG_SET).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSets(String key, List<String> flagSets) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, flagSets, null, new EvaluationOptions(null), MethodEnum.TREATMENTS_BY_FLAG_SETS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSets(String key, List<String> flagSets, Map<String, Object> attributes) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, flagSets, attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS_BY_FLAG_SETS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSets(Key key, List<String> flagSets, Map<String, Object> attributes) {
        return this.getTreatmentsBySetsWithConfigInternal(key.matchingKey(), key.bucketingKey(), flagSets, attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS_BY_FLAG_SETS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSet(String key, String flagSet) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, new ArrayList<String>(Arrays.asList(flagSet)), null, new EvaluationOptions(null), MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SET);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSet(String key, String flagSet, Map<String, Object> attributes) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, new ArrayList<String>(Arrays.asList(flagSet)), attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SET);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSet(Key key, String flagSet, Map<String, Object> attributes) {
        return this.getTreatmentsBySetsWithConfigInternal(key.matchingKey(), key.bucketingKey(), new ArrayList<String>(Arrays.asList(flagSet)), attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SET);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSets(String key, List<String> flagSets) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, flagSets, null, new EvaluationOptions(null), MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SETS);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSets(String key, List<String> flagSets, Map<String, Object> attributes) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, flagSets, attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SETS);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSets(Key key, List<String> flagSets, Map<String, Object> attributes) {
        return this.getTreatmentsBySetsWithConfigInternal(key.matchingKey(), key.bucketingKey(), flagSets, attributes, new EvaluationOptions(null), MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SETS);
    }

    @Override
    public String getTreatment(String key, String featureFlagName, EvaluationOptions evaluationOptions) {
        return this.getTreatment(key, featureFlagName, Collections.emptyMap(), evaluationOptions);
    }

    @Override
    public String getTreatment(String key, String featureFlagName, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentWithConfigInternal(key, null, featureFlagName, attributes, evaluationOptions, MethodEnum.TREATMENT).treatment();
    }

    @Override
    public String getTreatment(Key key, String featureFlagName, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentWithConfigInternal(key.matchingKey(), key.bucketingKey(), featureFlagName, attributes, evaluationOptions, MethodEnum.TREATMENT).treatment();
    }

    @Override
    public Map<String, String> getTreatments(String key, List<String> featureFlagNames, EvaluationOptions evaluationOptions) {
        return this.getTreatments(key, featureFlagNames, Collections.emptyMap(), evaluationOptions);
    }

    @Override
    public Map<String, String> getTreatments(String key, List<String> featureFlagNames, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsWithConfigInternal(key, null, featureFlagNames, attributes, evaluationOptions, MethodEnum.TREATMENTS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, String> getTreatments(Key key, List<String> featureFlagNames, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsWithConfigInternal(key.matchingKey(), key.bucketingKey(), featureFlagNames, attributes, evaluationOptions, MethodEnum.TREATMENTS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public SplitResult getTreatmentWithConfig(String key, String featureFlagName, EvaluationOptions evaluationOptions) {
        return this.getTreatmentWithConfigInternal(key, null, featureFlagName, Collections.emptyMap(), evaluationOptions, MethodEnum.TREATMENT_WITH_CONFIG);
    }

    @Override
    public SplitResult getTreatmentWithConfig(Key key, String featureFlagName, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentWithConfigInternal(key.matchingKey(), key.bucketingKey(), featureFlagName, attributes, evaluationOptions, MethodEnum.TREATMENT_WITH_CONFIG);
    }

    @Override
    public SplitResult getTreatmentWithConfig(String key, String featureFlagName, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentWithConfigInternal(key, null, featureFlagName, attributes, evaluationOptions, MethodEnum.TREATMENT_WITH_CONFIG);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfig(String key, List<String> featureFlagNames, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsWithConfigInternal(key, null, featureFlagNames, attributes, evaluationOptions, MethodEnum.TREATMENTS_WITH_CONFIG);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfig(String key, List<String> featureFlagNames, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsWithConfigInternal(key, null, featureFlagNames, null, evaluationOptions, MethodEnum.TREATMENTS_WITH_CONFIG);
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSet(String key, String flagSet, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, new ArrayList<String>(Arrays.asList(flagSet)), attributes, evaluationOptions, MethodEnum.TREATMENTS_BY_FLAG_SET).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSets(String key, List<String> flagSets, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, flagSets, null, evaluationOptions, MethodEnum.TREATMENTS_BY_FLAG_SETS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSets(String key, List<String> flagSets, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, flagSets, attributes, evaluationOptions, MethodEnum.TREATMENTS_BY_FLAG_SETS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSet(String key, String flagSet, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, new ArrayList<String>(Arrays.asList(flagSet)), null, evaluationOptions, MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SET);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSet(String key, String flagSet, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, new ArrayList<String>(Arrays.asList(flagSet)), attributes, evaluationOptions, MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SET);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSets(String key, List<String> flagSets, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, flagSets, null, evaluationOptions, MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SETS);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSets(String key, List<String> flagSets, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, flagSets, attributes, evaluationOptions, MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SETS);
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSet(String key, String flagSet, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key, null, new ArrayList<String>(Arrays.asList(flagSet)), null, evaluationOptions, MethodEnum.TREATMENTS_BY_FLAG_SET).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfig(Key key, List<String> featureFlagNames, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsWithConfigInternal(key.matchingKey(), key.bucketingKey(), featureFlagNames, attributes, evaluationOptions, MethodEnum.TREATMENTS_WITH_CONFIG);
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSet(Key key, String flagSet, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key.matchingKey(), key.bucketingKey(), new ArrayList<String>(Arrays.asList(flagSet)), attributes, evaluationOptions, MethodEnum.TREATMENTS_BY_FLAG_SET).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, String> getTreatmentsByFlagSets(Key key, List<String> flagSets, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key.matchingKey(), key.bucketingKey(), flagSets, attributes, evaluationOptions, MethodEnum.TREATMENTS_BY_FLAG_SETS).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SplitResult)e.getValue()).treatment()));
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSet(Key key, String flagSet, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key.matchingKey(), key.bucketingKey(), new ArrayList<String>(Arrays.asList(flagSet)), attributes, evaluationOptions, MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SET);
    }

    @Override
    public Map<String, SplitResult> getTreatmentsWithConfigByFlagSets(Key key, List<String> flagSets, Map<String, Object> attributes, EvaluationOptions evaluationOptions) {
        return this.getTreatmentsBySetsWithConfigInternal(key.matchingKey(), key.bucketingKey(), flagSets, attributes, evaluationOptions, MethodEnum.TREATMENTS_WITH_CONFIG_BY_FLAG_SETS);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType) {
        Event event = this.createEvent(key, trafficType, eventType);
        return this.track(event);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, double value) {
        Event event = this.createEvent(key, trafficType, eventType);
        event.value = value;
        return this.track(event);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, Map<String, Object> properties) {
        Event event = this.createEvent(key, trafficType, eventType);
        event.properties = new HashMap<String, Object>(properties);
        return this.track(event);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, double value, Map<String, Object> properties) {
        Event event = this.createEvent(key, trafficType, eventType);
        event.properties = new HashMap<String, Object>(properties);
        event.value = value;
        return this.track(event);
    }

    @Override
    public void blockUntilReady() throws TimeoutException, InterruptedException {
        long startTime = System.currentTimeMillis();
        if (this._config.blockUntilReady() <= 0) {
            throw new IllegalArgumentException("setBlockUntilReadyTimeout must be positive but in config was: " + this._config.blockUntilReady());
        }
        if (!this._gates.waitUntilInternalReady(this._config.blockUntilReady())) {
            throw new TimeoutException("SDK was not ready in " + this._config.blockUntilReady() + " milliseconds");
        }
        _log.debug(String.format("Split SDK ready in %d ms", System.currentTimeMillis() - startTime));
    }

    @Override
    public void destroy() {
        this._container.destroy();
    }

    private boolean track(Event event) {
        long initTime = System.currentTimeMillis();
        if (this._container.isDestroyed()) {
            _log.error(CLIENT_DESTROY);
            return false;
        }
        Optional<String> trafficTypeResult = TrafficTypeValidator.isValid(event.trafficTypeName, this._splitCacheConsumer, "track");
        if (!trafficTypeResult.isPresent()) {
            return false;
        }
        event.trafficTypeName = trafficTypeResult.get();
        if (!EventsValidator.typeIsValid(event.eventTypeId, "track")) {
            return false;
        }
        if (!KeyValidator.isValid(event.key, "key", this._config.maxStringLength(), "track")) {
            return false;
        }
        EventsValidator.EventValidatorResult propertiesResult = EventsValidator.propertiesAreValid(event.properties);
        if (!propertiesResult.getSuccess()) {
            return false;
        }
        event.properties = propertiesResult.getValue();
        this._telemetryEvaluationProducer.recordLatency(MethodEnum.TRACK, System.currentTimeMillis() - initTime);
        return this._eventsStorageProducer.track(event, propertiesResult.getEventSize());
    }

    private SplitResult getTreatmentWithConfigInternal(String matchingKey, String bucketingKey, String featureFlag, Map<String, Object> attributes, EvaluationOptions evaluationOptions, MethodEnum methodEnum) {
        long initTime = System.currentTimeMillis();
        try {
            this.checkSDKReady(methodEnum, Arrays.asList(featureFlag));
            if (this._container.isDestroyed()) {
                _log.error(CLIENT_DESTROY);
                return SPLIT_RESULT_CONTROL;
            }
            if (!KeyValidator.isValid(matchingKey, MATCHING_KEY, this._config.maxStringLength(), methodEnum.getMethod())) {
                return SPLIT_RESULT_CONTROL;
            }
            if (!KeyValidator.bucketingKeyIsValid(bucketingKey, this._config.maxStringLength(), methodEnum.getMethod())) {
                return SPLIT_RESULT_CONTROL;
            }
            Optional<String> splitNameResult = SplitNameValidator.isValid(featureFlag, methodEnum.getMethod());
            if (!splitNameResult.isPresent()) {
                return SPLIT_RESULT_CONTROL;
            }
            featureFlag = splitNameResult.get();
            long start = System.currentTimeMillis();
            EvaluatorImp.TreatmentLabelAndChangeNumber result = this._evaluator.evaluateFeature(matchingKey, bucketingKey, featureFlag, attributes);
            if (result.treatment.equals("control") && result.label.equals("definition not found") && this._gates.isSDKReady()) {
                _log.warn(String.format("%s: you passed \"%s\" that does not exist in this environment, please double check what feature flags exist in the Split user interface.", methodEnum.getMethod(), featureFlag));
                return SPLIT_RESULT_CONTROL;
            }
            this.recordStats(matchingKey, bucketingKey, featureFlag, start, result.treatment, String.format("sdk.%s", methodEnum.getMethod()), this._config.labelsEnabled() ? result.label : null, result.changeNumber, attributes, result.track, this.validateProperties(evaluationOptions.getProperties()));
            this._telemetryEvaluationProducer.recordLatency(methodEnum, System.currentTimeMillis() - initTime);
            return new SplitResult(result.treatment, result.configurations);
        }
        catch (Exception e) {
            try {
                this._telemetryEvaluationProducer.recordException(methodEnum);
                _log.error(CATCHALL_EXCEPTION, (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return SPLIT_RESULT_CONTROL;
        }
    }

    private String validateProperties(Map<String, Object> properties) {
        if (properties == null) {
            return null;
        }
        ImpressionPropertiesValidator.ImpressionPropertiesValidatorResult iPValidatorResult = ImpressionPropertiesValidator.propertiesAreValid(properties);
        return new GsonBuilder().create().toJson(iPValidatorResult.getValue());
    }

    private Map<String, SplitResult> getTreatmentsWithConfigInternal(String matchingKey, String bucketingKey, List<String> featureFlagNames, Map<String, Object> attributes, EvaluationOptions evaluationOptions, MethodEnum methodEnum) {
        long initTime = System.currentTimeMillis();
        if (featureFlagNames == null) {
            _log.error(String.format("%s: featureFlagNames must be a non-empty array", methodEnum.getMethod()));
            return new HashMap<String, SplitResult>();
        }
        try {
            this.checkSDKReady(methodEnum, featureFlagNames);
            Map<String, SplitResult> result = this.validateBeforeEvaluate(featureFlagNames, matchingKey, methodEnum, bucketingKey);
            if (result != null) {
                return result;
            }
            featureFlagNames = SplitNameValidator.areValid(featureFlagNames, methodEnum.getMethod());
            Map<String, EvaluatorImp.TreatmentLabelAndChangeNumber> evaluatorResult = this._evaluator.evaluateFeatures(matchingKey, bucketingKey, featureFlagNames, attributes);
            return this.processEvaluatorResult(evaluatorResult, methodEnum, matchingKey, bucketingKey, attributes, initTime, this.validateProperties(evaluationOptions.getProperties()));
        }
        catch (Exception e) {
            try {
                this._telemetryEvaluationProducer.recordException(methodEnum);
                _log.error(CATCHALL_EXCEPTION, (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.createMapControl(featureFlagNames);
        }
    }

    private Map<String, SplitResult> getTreatmentsBySetsWithConfigInternal(String matchingKey, String bucketingKey, List<String> sets, Map<String, Object> attributes, EvaluationOptions evaluationOptions, MethodEnum methodEnum) {
        long initTime = System.currentTimeMillis();
        if (sets == null || sets.isEmpty()) {
            _log.warn(String.format("%s: sets must be a non-empty array", methodEnum.getMethod()));
            return new HashMap<String, SplitResult>();
        }
        Set<String> cleanFlagSets = FlagSetsValidator.cleanup(sets);
        if ((cleanFlagSets = this.filterSetsAreInConfig(cleanFlagSets, methodEnum)).isEmpty()) {
            return new HashMap<String, SplitResult>();
        }
        ArrayList<String> featureFlagNames = new ArrayList<String>();
        try {
            this.checkSDKReady(methodEnum);
            Map<String, SplitResult> result = this.validateBeforeEvaluateByFlagSets(matchingKey, methodEnum, bucketingKey);
            if (result != null) {
                return result;
            }
            Map<String, EvaluatorImp.TreatmentLabelAndChangeNumber> evaluatorResult = this._evaluator.evaluateFeaturesByFlagSets(matchingKey, bucketingKey, new ArrayList<String>(cleanFlagSets), attributes);
            return this.processEvaluatorResult(evaluatorResult, methodEnum, matchingKey, bucketingKey, attributes, initTime, this.validateProperties(evaluationOptions.getProperties()));
        }
        catch (Exception e) {
            try {
                this._telemetryEvaluationProducer.recordException(methodEnum);
                _log.error(CATCHALL_EXCEPTION, (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.createMapControl(featureFlagNames);
        }
    }

    private Map<String, SplitResult> processEvaluatorResult(Map<String, EvaluatorImp.TreatmentLabelAndChangeNumber> evaluatorResult, MethodEnum methodEnum, String matchingKey, String bucketingKey, Map<String, Object> attributes, long initTime, String properties) {
        ArrayList<DecoratedImpression> decoratedImpressions = new ArrayList<DecoratedImpression>();
        HashMap<String, SplitResult> result = new HashMap<String, SplitResult>();
        evaluatorResult.keySet().forEach(t2 -> {
            if (((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t2)).treatment.equals("control") && ((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t2)).label.equals("definition not found") && this._gates.isSDKReady()) {
                _log.warn(String.format("%s: you passed \"%s\" that does not exist in this environment please double check what feature flags exist in the Split user interface.", methodEnum.getMethod(), t2));
                result.put((String)t2, SPLIT_RESULT_CONTROL);
            } else {
                result.put((String)t2, new SplitResult(((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t2)).treatment, ((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t2)).configurations));
                decoratedImpressions.add(new DecoratedImpression(new Impression(matchingKey, bucketingKey, (String)t2, ((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t2)).treatment, System.currentTimeMillis(), ((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t2)).label, ((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t2)).changeNumber, attributes, properties), ((EvaluatorImp.TreatmentLabelAndChangeNumber)evaluatorResult.get((Object)t2)).track));
            }
        });
        this._telemetryEvaluationProducer.recordLatency(methodEnum, System.currentTimeMillis() - initTime);
        if (!decoratedImpressions.isEmpty()) {
            this._impressionManager.track(decoratedImpressions);
        }
        return result;
    }

    private Map<String, SplitResult> validateBeforeEvaluateByFlagSets(String matchingKey, MethodEnum methodEnum, String bucketingKey) {
        if (this._container.isDestroyed()) {
            _log.error(CLIENT_DESTROY);
            return new HashMap<String, SplitResult>();
        }
        if (!KeyValidator.isValid(matchingKey, MATCHING_KEY, this._config.maxStringLength(), methodEnum.getMethod())) {
            return new HashMap<String, SplitResult>();
        }
        if (!KeyValidator.bucketingKeyIsValid(bucketingKey, this._config.maxStringLength(), methodEnum.getMethod())) {
            return new HashMap<String, SplitResult>();
        }
        return null;
    }

    private Map<String, SplitResult> validateBeforeEvaluate(List<String> featureFlagNames, String matchingKey, MethodEnum methodEnum, String bucketingKey) {
        if (this._container.isDestroyed()) {
            _log.error(CLIENT_DESTROY);
            return this.createMapControl(featureFlagNames);
        }
        if (!KeyValidator.isValid(matchingKey, MATCHING_KEY, this._config.maxStringLength(), methodEnum.getMethod())) {
            return this.createMapControl(featureFlagNames);
        }
        if (!KeyValidator.bucketingKeyIsValid(bucketingKey, this._config.maxStringLength(), methodEnum.getMethod())) {
            return this.createMapControl(featureFlagNames);
        }
        if (featureFlagNames.isEmpty()) {
            _log.error(String.format("%s: featureFlagNames must be a non-empty array", methodEnum.getMethod()));
            return new HashMap<String, SplitResult>();
        }
        return null;
    }

    private Set<String> filterSetsAreInConfig(Set<String> sets, MethodEnum methodEnum) {
        HashSet<String> setsToReturn = new HashSet<String>();
        for (String set : sets) {
            if (!this._flagSetsFilter.intersect(set)) {
                _log.warn(String.format("%s: you passed %s which is not part of the configured FlagSetsFilter, ignoring Flag Set.", new Object[]{methodEnum, set}));
                continue;
            }
            setsToReturn.add(set);
        }
        return setsToReturn;
    }

    private void recordStats(String matchingKey, String bucketingKey, String featureFlagName, long start, String result, String operation, String label, Long changeNumber, Map<String, Object> attributes, boolean track, String properties) {
        try {
            this._impressionManager.track(Stream.of(new DecoratedImpression(new Impression(matchingKey, bucketingKey, featureFlagName, result, System.currentTimeMillis(), label, changeNumber, attributes, properties), track)).collect(Collectors.toList()));
        }
        catch (Throwable t2) {
            _log.error("Exception", t2);
        }
    }

    private Event createEvent(String key, String trafficType, String eventType) {
        Event event = new Event();
        event.eventTypeId = eventType;
        event.trafficTypeName = trafficType;
        event.key = key;
        event.timestamp = System.currentTimeMillis();
        return event;
    }

    private void checkSDKReady(MethodEnum methodEnum, List<String> featureFlagNames) {
        String toPrint;
        String string = toPrint = featureFlagNames.size() == 1 ? featureFlagNames.get(0) : String.join((CharSequence)",", featureFlagNames);
        if (!this._gates.isSDKReady()) {
            _log.warn(String.format("%s: the SDK is not ready, results may be incorrect for feature flag %s. Make sure to wait for SDK readiness before using this method", methodEnum.getMethod(), toPrint));
            this._telemetryConfigProducer.recordNonReadyUsage();
        }
    }

    private void checkSDKReady(MethodEnum methodEnum) {
        if (!this._gates.isSDKReady()) {
            _log.warn(String.format("%s: the SDK is not ready, results may be incorrect. Make sure to wait for SDK readiness before using this method", methodEnum.getMethod()));
            this._telemetryConfigProducer.recordNonReadyUsage();
        }
    }

    private Map<String, SplitResult> createMapControl(List<String> featureFlags) {
        HashMap<String, SplitResult> result = new HashMap<String, SplitResult>();
        featureFlags.forEach(s2 -> result.put((String)s2, SPLIT_RESULT_CONTROL));
        return result;
    }
}

