/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.impressions.ImpressionUtils;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import split.com.google.common.base.Preconditions;

public class ImpressionCounter {
    private final ConcurrentHashMap<Key, AtomicInteger> _counts = new ConcurrentHashMap();

    public void inc(String featureFlagName, long timeFrame, int amount) {
        AtomicInteger old;
        Key key = new Key(featureFlagName, ImpressionUtils.truncateTimeframe(timeFrame));
        AtomicInteger count = this._counts.get(key);
        if (Objects.isNull(count) && !Objects.isNull(old = this._counts.putIfAbsent(key, count = new AtomicInteger()))) {
            count = old;
        }
        count.addAndGet(amount);
    }

    public HashMap<Key, Integer> popAll() {
        HashMap<Key, Integer> toReturn = new HashMap<Key, Integer>();
        for (Key key : this._counts.keySet()) {
            AtomicInteger curr = this._counts.remove(key);
            toReturn.put(key, curr.get());
        }
        return toReturn;
    }

    public boolean isEmpty() {
        return this._counts.isEmpty();
    }

    public static class Key {
        private final String _featureName;
        private final long _timeFrame;

        public Key(String featureFlagName, long timeframe) {
            this._featureName = Preconditions.checkNotNull(featureFlagName);
            this._timeFrame = timeframe;
        }

        public String featureName() {
            return this._featureName;
        }

        public long timeFrame() {
            return this._timeFrame;
        }

        public int hashCode() {
            return Objects.hash(this._featureName, this._timeFrame);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this._featureName, key._featureName) && Objects.equals(this._timeFrame, key._timeFrame);
        }
    }
}

