/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionHasher;
import java.util.Objects;
import split.com.google.common.cache.Cache;
import split.com.google.common.cache.CacheBuilder;

public class ImpressionObserver {
    private final Cache<Long, Long> _cache;

    public ImpressionObserver(long size) {
        this._cache = CacheBuilder.newBuilder().maximumSize(size).concurrencyLevel(4).build();
    }

    public Long testAndSet(Impression impression) {
        if (null == impression) {
            return null;
        }
        Long hash = ImpressionHasher.process(impression);
        Long previous = this._cache.getIfPresent(hash);
        this._cache.put(hash, impression.time());
        return Objects.isNull(previous) ? null : Long.valueOf(Math.min(previous, impression.time()));
    }
}

