/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.client.dtos.ExcludedSegments;
import io.split.engine.evaluator.EvaluationContext;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedRuleBasedSegment;
import io.split.engine.matchers.Matcher;
import java.util.List;
import java.util.Map;
import split.com.google.common.base.Preconditions;

public class RuleBasedSegmentMatcher
implements Matcher {
    private final String _segmentName;

    public RuleBasedSegmentMatcher(String segmentName) {
        this._segmentName = Preconditions.checkNotNull(segmentName);
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, EvaluationContext evaluationContext) {
        if (!(matchValue instanceof String)) {
            return false;
        }
        ParsedRuleBasedSegment parsedRuleBasedSegment = evaluationContext.getRuleBasedSegmentCache().get(this._segmentName);
        if (parsedRuleBasedSegment == null) {
            return false;
        }
        if (parsedRuleBasedSegment.excludedKeys().contains(matchValue)) {
            return false;
        }
        if (this.matchExcludedSegments(parsedRuleBasedSegment.excludedSegments(), matchValue, bucketingKey, attributes, evaluationContext)) {
            return false;
        }
        return this.matchConditions(parsedRuleBasedSegment.parsedConditions(), matchValue, bucketingKey, attributes, evaluationContext);
    }

    private boolean matchExcludedSegments(List<ExcludedSegments> excludedSegments, Object matchValue, String bucketingKey, Map<String, Object> attributes, EvaluationContext evaluationContext) {
        for (ExcludedSegments excludedSegment : excludedSegments) {
            RuleBasedSegmentMatcher excludedRbsMatcher;
            if (excludedSegment.isStandard() && evaluationContext.getSegmentCache().isInSegment(excludedSegment.name, (String)matchValue)) {
                return true;
            }
            if (!excludedSegment.isRuleBased() || !(excludedRbsMatcher = new RuleBasedSegmentMatcher(excludedSegment.name)).match(matchValue, bucketingKey, attributes, evaluationContext)) continue;
            return true;
        }
        return false;
    }

    private boolean matchConditions(List<ParsedCondition> conditions, Object matchValue, String bucketingKey, Map<String, Object> attributes, EvaluationContext evaluationContext) {
        for (ParsedCondition parsedCondition : conditions) {
            if (!parsedCondition.matcher().match((String)matchValue, bucketingKey, attributes, evaluationContext)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._segmentName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleBasedSegmentMatcher)) {
            return false;
        }
        RuleBasedSegmentMatcher other = (RuleBasedSegmentMatcher)obj;
        return this._segmentName.equals(other._segmentName);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("in segment ");
        bldr.append(this._segmentName);
        return bldr.toString();
    }

    public String getSegmentName() {
        return this._segmentName;
    }
}

