/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.hc.core5.http.io;

import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import split.org.apache.hc.core5.annotation.Contract;
import split.org.apache.hc.core5.annotation.ThreadingBehavior;
import split.org.apache.hc.core5.util.Args;
import split.org.apache.hc.core5.util.TimeValue;
import split.org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class SocketConfig {
    private static final Timeout DEFAULT_SOCKET_TIMEOUT = Timeout.ofMinutes(3L);
    public static final SocketConfig DEFAULT = new Builder().build();
    private final Timeout soTimeout;
    private final boolean soReuseAddress;
    private final TimeValue soLinger;
    private final boolean soKeepAlive;
    private final boolean tcpNoDelay;
    private final int sndBufSize;
    private final int rcvBufSize;
    private final int backlogSize;
    private final int tcpKeepIdle;
    private final int tcpKeepInterval;
    private final int tcpKeepCount;
    private final SocketAddress socksProxyAddress;

    SocketConfig(Timeout soTimeout, boolean soReuseAddress, TimeValue soLinger, boolean soKeepAlive, boolean tcpNoDelay, int sndBufSize, int rcvBufSize, int backlogSize, int tcpKeepIdle, int tcpKeepInterval, int tcpKeepCount, SocketAddress socksProxyAddress) {
        this.soTimeout = soTimeout;
        this.soReuseAddress = soReuseAddress;
        this.soLinger = soLinger;
        this.soKeepAlive = soKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.sndBufSize = sndBufSize;
        this.rcvBufSize = rcvBufSize;
        this.backlogSize = backlogSize;
        this.tcpKeepIdle = tcpKeepIdle;
        this.tcpKeepInterval = tcpKeepInterval;
        this.tcpKeepCount = tcpKeepCount;
        this.socksProxyAddress = socksProxyAddress;
    }

    public Timeout getSoTimeout() {
        return this.soTimeout;
    }

    public boolean isSoReuseAddress() {
        return this.soReuseAddress;
    }

    public TimeValue getSoLinger() {
        return this.soLinger;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getSndBufSize() {
        return this.sndBufSize;
    }

    public int getRcvBufSize() {
        return this.rcvBufSize;
    }

    public int getBacklogSize() {
        return this.backlogSize;
    }

    public int getTcpKeepIdle() {
        return this.tcpKeepIdle;
    }

    public int getTcpKeepInterval() {
        return this.tcpKeepInterval;
    }

    public int getTcpKeepCount() {
        return this.tcpKeepCount;
    }

    public SocketAddress getSocksProxyAddress() {
        return this.socksProxyAddress;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[soTimeout=").append(this.soTimeout).append(", soReuseAddress=").append(this.soReuseAddress).append(", soLinger=").append(this.soLinger).append(", soKeepAlive=").append(this.soKeepAlive).append(", tcpNoDelay=").append(this.tcpNoDelay).append(", sndBufSize=").append(this.sndBufSize).append(", rcvBufSize=").append(this.rcvBufSize).append(", backlogSize=").append(this.backlogSize).append(", tcpKeepIdle=").append(this.tcpKeepIdle).append(", tcpKeepInterval=").append(this.tcpKeepInterval).append(", tcpKeepCount=").append(this.tcpKeepCount).append(", socksProxyAddress=").append(this.socksProxyAddress).append("]");
        return builder.toString();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(SocketConfig config) {
        Args.notNull(config, "Socket config");
        return new Builder().setSoTimeout(config.getSoTimeout()).setSoReuseAddress(config.isSoReuseAddress()).setSoLinger(config.getSoLinger()).setSoKeepAlive(config.isSoKeepAlive()).setTcpNoDelay(config.isTcpNoDelay()).setSndBufSize(config.getSndBufSize()).setRcvBufSize(config.getRcvBufSize()).setBacklogSize(config.getBacklogSize()).setTcpKeepIdle(config.getTcpKeepIdle()).setTcpKeepInterval(config.getTcpKeepInterval()).setTcpKeepCount(config.getTcpKeepCount()).setSocksProxyAddress(config.getSocksProxyAddress());
    }

    static /* synthetic */ Timeout access$000() {
        return DEFAULT_SOCKET_TIMEOUT;
    }

    public static class Builder {
        private Timeout soTimeout = SocketConfig.access$000();
        private boolean soReuseAddress = false;
        private TimeValue soLinger = TimeValue.NEG_ONE_SECOND;
        private boolean soKeepAlive = false;
        private boolean tcpNoDelay = true;
        private int sndBufSize = 0;
        private int rcvBufSize = 0;
        private int backlogSize = 0;
        private int tcpKeepIdle = -1;
        private int tcpKeepInterval = -1;
        private int tcpKeepCount = -1;
        private SocketAddress socksProxyAddress = null;

        Builder() {
        }

        public Builder setSoTimeout(int soTimeout, TimeUnit timeUnit) {
            this.soTimeout = Timeout.of(soTimeout, timeUnit);
            return this;
        }

        public Builder setSoTimeout(Timeout soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder setSoReuseAddress(boolean soReuseAddress) {
            this.soReuseAddress = soReuseAddress;
            return this;
        }

        public Builder setSoLinger(int soLinger, TimeUnit timeUnit) {
            this.soLinger = Timeout.of(soLinger, timeUnit);
            return this;
        }

        public Builder setSoLinger(TimeValue soLinger) {
            this.soLinger = soLinger;
            return this;
        }

        public Builder setSoKeepAlive(boolean soKeepAlive) {
            this.soKeepAlive = soKeepAlive;
            return this;
        }

        public Builder setTcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return this;
        }

        public Builder setSndBufSize(int sndBufSize) {
            this.sndBufSize = sndBufSize;
            return this;
        }

        public Builder setRcvBufSize(int rcvBufSize) {
            this.rcvBufSize = rcvBufSize;
            return this;
        }

        public Builder setBacklogSize(int backlogSize) {
            this.backlogSize = backlogSize;
            return this;
        }

        public Builder setTcpKeepIdle(int tcpKeepIdle) {
            this.tcpKeepIdle = tcpKeepIdle;
            return this;
        }

        public Builder setTcpKeepInterval(int tcpKeepInterval) {
            this.tcpKeepInterval = tcpKeepInterval;
            return this;
        }

        public Builder setTcpKeepCount(int tcpKeepCount) {
            this.tcpKeepCount = tcpKeepCount;
            return this;
        }

        public Builder setSocksProxyAddress(SocketAddress socksProxyAddress) {
            this.socksProxyAddress = socksProxyAddress;
            return this;
        }

        public SocketConfig build() {
            return new SocketConfig(Timeout.defaultsToInfinite(this.soTimeout), this.soReuseAddress, this.soLinger != null ? this.soLinger : TimeValue.NEG_ONE_SECOND, this.soKeepAlive, this.tcpNoDelay, this.sndBufSize, this.rcvBufSize, this.backlogSize, this.tcpKeepIdle, this.tcpKeepInterval, this.tcpKeepCount, this.socksProxyAddress);
        }
    }
}

