/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.hc.core5.http.impl;

import java.net.InetSocketAddress;
import split.org.apache.hc.core5.function.Resolver;
import split.org.apache.hc.core5.http.HttpHost;
import split.org.apache.hc.core5.http.URIScheme;

public final class DefaultAddressResolver
implements Resolver<HttpHost, InetSocketAddress> {
    public static final DefaultAddressResolver INSTANCE = new DefaultAddressResolver();

    @Override
    public InetSocketAddress resolve(HttpHost host) {
        if (host == null) {
            return null;
        }
        int port = host.getPort();
        if (port < 0) {
            String scheme = host.getSchemeName();
            if (URIScheme.HTTP.same(scheme)) {
                port = 80;
            } else if (URIScheme.HTTPS.same(scheme)) {
                port = 443;
            }
        }
        if (host.getAddress() != null) {
            return new InetSocketAddress(host.getAddress(), port);
        }
        return new InetSocketAddress(host.getHostName(), port);
    }
}

