/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.CustomHeaderDecorator;
import io.split.client.NoOpHeaderDecorator;
import io.split.client.dtos.RequestContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class RequestDecorator {
    CustomHeaderDecorator _headerDecorator;
    private static final Set<String> forbiddenHeaders = new HashSet<String>(Arrays.asList("splitsdkversion", "splitmachineip", "splitmachinename", "splitimpressionsmode", "host", "referrer", "content-type", "content-length", "content-encoding", "accept", "keep-alive", "x-fastly-debug"));

    public RequestDecorator(CustomHeaderDecorator headerDecorator) {
        this._headerDecorator = headerDecorator == null ? new NoOpHeaderDecorator() : headerDecorator;
    }

    public RequestContext decorateHeaders(RequestContext request) {
        try {
            return new RequestContext(this._headerDecorator.getHeaderOverrides(request).entrySet().stream().filter(e -> !forbiddenHeaders.contains(((String)e.getKey()).toLowerCase())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(String.format("Problem adding custom headers to request decorator: %s", e2), e2);
        }
    }
}

