/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.dtos;

import io.split.client.dtos.ProxyCredentialsProvider;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import split.org.apache.hc.core5.http.HttpHost;

public class ProxyConfiguration {
    private final HttpHost _proxyHost;
    private ProxyCredentialsProvider _provider;
    private final InputStream _p12File;
    private final String _passKey;

    private ProxyConfiguration(HttpHost proxyHost, ProxyCredentialsProvider proxyCredentialsProvider, InputStream p12File, String passKey) {
        this._proxyHost = proxyHost;
        this._p12File = p12File;
        this._passKey = passKey;
        this._provider = proxyCredentialsProvider;
    }

    public HttpHost getHost() {
        return this._proxyHost;
    }

    public InputStream getP12File() {
        return this._p12File;
    }

    public String getPassKey() {
        return this._passKey;
    }

    public ProxyCredentialsProvider getProxyCredentialsProvider() {
        return this._provider;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ProxyCredentialsProvider _provider;
        private HttpHost _proxyHost;
        private InputStream _p12File;
        private String _passKey;

        public Builder credentialsProvider(ProxyCredentialsProvider provider) {
            this._provider = provider;
            return this;
        }

        public Builder url(URL url) throws MalformedURLException {
            try {
                this._proxyHost = new HttpHost(url.getProtocol(), url.getHost(), url.getPort());
            }
            catch (Exception exc) {
                throw new MalformedURLException("Proxy configuration is invalid. The proxy `url` is malformed");
            }
            return this;
        }

        public Builder mtls(InputStream p12File, String passKey) {
            this._passKey = passKey;
            this._p12File = p12File;
            return this;
        }

        public ProxyConfiguration build() {
            if (this._proxyHost == null) {
                throw new IllegalArgumentException("Proxy configuration is invalid. The proxy `url` was not provided");
            }
            return new ProxyConfiguration(this._proxyHost, this._provider, this._p12File, this._passKey);
        }
    }
}

