/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.utils;

import io.split.client.dtos.Excluded;
import io.split.client.dtos.ExcludedSegments;
import io.split.client.dtos.RuleBasedSegment;
import io.split.client.dtos.Status;
import io.split.client.utils.RuleBasedSegmentsToUpdate;
import io.split.engine.experiments.ParsedRuleBasedSegment;
import io.split.engine.experiments.RuleBasedSegmentParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedSegmentProcessor {
    private static final Logger _log = LoggerFactory.getLogger(RuleBasedSegmentProcessor.class);

    private RuleBasedSegmentProcessor() {
        throw new IllegalStateException("Utility class");
    }

    public static RuleBasedSegmentsToUpdate processRuleBasedSegmentChanges(RuleBasedSegmentParser ruleBasedSegmentParser, List<RuleBasedSegment> ruleBasedSegments) {
        ArrayList<ParsedRuleBasedSegment> toAdd = new ArrayList<ParsedRuleBasedSegment>();
        ArrayList<String> toRemove = new ArrayList<String>();
        HashSet<String> segments = new HashSet<String>();
        for (RuleBasedSegment ruleBasedSegment : ruleBasedSegments) {
            ruleBasedSegment.excluded = RuleBasedSegmentProcessor.checkExcluded(ruleBasedSegment.excluded);
            if (ruleBasedSegment.status != Status.ACTIVE) {
                toRemove.add(ruleBasedSegment.name);
                continue;
            }
            ParsedRuleBasedSegment parsedRuleBasedSegment = ruleBasedSegmentParser.parse(ruleBasedSegment);
            if (parsedRuleBasedSegment == null) {
                _log.debug(String.format("We could not parse the rule based segment definition for: %s", ruleBasedSegment.name));
                continue;
            }
            segments.addAll(parsedRuleBasedSegment.getSegmentsNames());
            toAdd.add(parsedRuleBasedSegment);
        }
        return new RuleBasedSegmentsToUpdate(toAdd, toRemove, segments);
    }

    private static Excluded createEmptyExcluded() {
        Excluded excluded = new Excluded();
        excluded.segments = new ArrayList<ExcludedSegments>();
        excluded.keys = new ArrayList<String>();
        return excluded;
    }

    private static Excluded checkExcluded(Excluded excluded) {
        if (excluded == null) {
            excluded = RuleBasedSegmentProcessor.createEmptyExcluded();
        }
        if (excluded.segments == null) {
            excluded.segments = new ArrayList<ExcludedSegments>();
        }
        if (excluded.keys == null) {
            excluded.keys = new ArrayList<String>();
        }
        return excluded;
    }
}

