/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import io.split.client.RequestDecorator;
import io.split.service.SplitHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public class SplitAPI {
    private final SplitHttpClient _httpClient;
    private final CloseableHttpClient _sseHttpClient;
    private final RequestDecorator _requestDecorator;
    private static final Logger _log = LoggerFactory.getLogger(SplitAPI.class);

    private SplitAPI(SplitHttpClient httpClient, CloseableHttpClient sseHttpClient, RequestDecorator requestDecorator) {
        this._httpClient = httpClient;
        this._sseHttpClient = sseHttpClient;
        this._requestDecorator = requestDecorator;
    }

    public static SplitAPI build(SplitHttpClient httpClient, CloseableHttpClient sseHttpClient, RequestDecorator requestDecorator) {
        return new SplitAPI(httpClient, sseHttpClient, requestDecorator);
    }

    public SplitHttpClient getHttpClient() {
        return this._httpClient;
    }

    public CloseableHttpClient getSseHttpClient() {
        return this._sseHttpClient;
    }

    public RequestDecorator getRequestDecorator() {
        return this._requestDecorator;
    }

    public void close() {
        try {
            this._httpClient.close();
        }
        catch (Exception e) {
            _log.error("Error trying to close regular http client", (Throwable)e);
        }
        try {
            this._sseHttpClient.close();
        }
        catch (Exception e) {
            _log.error("Error trying to close sseHttpClient", (Throwable)e);
        }
    }
}

