/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.evaluator;

import io.split.client.dtos.ConditionType;
import io.split.client.dtos.FallbackTreatment;
import io.split.client.dtos.FallbackTreatmentCalculator;
import io.split.client.exceptions.ChangeNumberExceptionWrapper;
import io.split.engine.evaluator.EvaluationContext;
import io.split.engine.evaluator.Evaluator;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.splitter.Splitter;
import io.split.storages.RuleBasedSegmentCacheConsumer;
import io.split.storages.SegmentCacheConsumer;
import io.split.storages.SplitCacheConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class EvaluatorImp
implements Evaluator {
    private static final Logger _log = LoggerFactory.getLogger(EvaluatorImp.class);
    private final SegmentCacheConsumer _segmentCacheConsumer;
    private final EvaluationContext _evaluationContext;
    private final SplitCacheConsumer _splitCacheConsumer;
    private final FallbackTreatmentCalculator _fallbackTreatmentCalculator;
    private final String _evaluatorException = "Evaluator Exception";

    public EvaluatorImp(SplitCacheConsumer splitCacheConsumer, SegmentCacheConsumer segmentCache, RuleBasedSegmentCacheConsumer ruleBasedSegmentCacheConsumer, FallbackTreatmentCalculator fallbackTreatmentCalculator) {
        this._splitCacheConsumer = Preconditions.checkNotNull(splitCacheConsumer);
        this._segmentCacheConsumer = Preconditions.checkNotNull(segmentCache);
        this._evaluationContext = new EvaluationContext(this, this._segmentCacheConsumer, ruleBasedSegmentCacheConsumer);
        this._fallbackTreatmentCalculator = fallbackTreatmentCalculator;
    }

    @Override
    public TreatmentLabelAndChangeNumber evaluateFeature(String matchingKey, String bucketingKey, String featureFlag, Map<String, Object> attributes) {
        ParsedSplit parsedSplit = this._splitCacheConsumer.get(featureFlag);
        return this.evaluateParsedSplit(matchingKey, bucketingKey, attributes, parsedSplit, featureFlag);
    }

    @Override
    public Map<String, TreatmentLabelAndChangeNumber> evaluateFeatures(String matchingKey, String bucketingKey, List<String> featureFlags, Map<String, Object> attributes) {
        HashMap<String, TreatmentLabelAndChangeNumber> results = new HashMap<String, TreatmentLabelAndChangeNumber>();
        Map<String, ParsedSplit> parsedSplits = this._splitCacheConsumer.fetchMany(featureFlags);
        if (parsedSplits == null) {
            return results;
        }
        featureFlags.forEach(s2 -> results.put((String)s2, this.evaluateParsedSplit(matchingKey, bucketingKey, attributes, (ParsedSplit)parsedSplits.get(s2), (String)s2)));
        return results;
    }

    @Override
    public Map<String, TreatmentLabelAndChangeNumber> evaluateFeaturesByFlagSets(String key, String bucketingKey, List<String> flagSets, Map<String, Object> attributes) {
        List<String> flagSetsWithNames = this.getFeatureFlagNamesByFlagSets(flagSets);
        try {
            return this.evaluateFeatures(key, bucketingKey, flagSetsWithNames, attributes);
        }
        catch (Exception e) {
            _log.error("Evaluator Exception", (Throwable)e);
            return this.createMapControl(flagSetsWithNames, "exception");
        }
    }

    private Map<String, TreatmentLabelAndChangeNumber> createMapControl(List<String> featureFlags, String label) {
        HashMap<String, TreatmentLabelAndChangeNumber> result = new HashMap<String, TreatmentLabelAndChangeNumber>();
        featureFlags.forEach(s2 -> result.put((String)s2, this.checkFallbackTreatment((String)s2, label)));
        return result;
    }

    private TreatmentLabelAndChangeNumber checkFallbackTreatment(String featureName, String label) {
        FallbackTreatment fallbackTreatment = this._fallbackTreatmentCalculator.resolve(featureName, label);
        return new TreatmentLabelAndChangeNumber(fallbackTreatment.getTreatment(), fallbackTreatment.getLabel(), null, this.getFallbackConfig(fallbackTreatment), false);
    }

    private List<String> getFeatureFlagNamesByFlagSets(List<String> flagSets) {
        HashSet<String> ffNamesToReturn = new HashSet<String>();
        Map<String, HashSet<String>> namesByFlagSets = this._splitCacheConsumer.getNamesByFlagSets(flagSets);
        for (String set : flagSets) {
            HashSet<String> flags = namesByFlagSets.get(set);
            if (flags == null || flags.isEmpty()) {
                _log.warn(String.format("You passed %s Flag Set that does not contain cached feature flag names, please double check what Flag Sets are in use in the Split user interface.", set));
                continue;
            }
            ffNamesToReturn.addAll(flags);
        }
        return new ArrayList<String>(ffNamesToReturn);
    }

    private TreatmentLabelAndChangeNumber getTreatment(String matchingKey, String bucketingKey, ParsedSplit parsedSplit, Map<String, Object> attributes) throws ChangeNumberExceptionWrapper {
        try {
            String config = this.getConfig(parsedSplit, parsedSplit.defaultTreatment());
            if (parsedSplit.killed()) {
                return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "killed", parsedSplit.changeNumber(), config, parsedSplit.impressionsDisabled());
            }
            String bk = this.getBucketingKey(bucketingKey, matchingKey);
            if (!parsedSplit.prerequisitesMatcher().match(matchingKey, bk, attributes, this._evaluationContext)) {
                return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "prerequisites not met", parsedSplit.changeNumber(), config, parsedSplit.impressionsDisabled());
            }
            boolean inRollout = false;
            for (ParsedCondition parsedCondition : parsedSplit.parsedConditions()) {
                if (this.checkRollout(inRollout, parsedCondition)) {
                    int bucket;
                    if (parsedSplit.trafficAllocation() < 100 && (bucket = Splitter.getBucket(bk, parsedSplit.trafficAllocationSeed(), parsedSplit.algo())) > parsedSplit.trafficAllocation()) {
                        config = this.getConfig(parsedSplit, parsedSplit.defaultTreatment());
                        return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "not in split", parsedSplit.changeNumber(), config, parsedSplit.impressionsDisabled());
                    }
                    inRollout = true;
                }
                if (!parsedCondition.matcher().match(matchingKey, bucketingKey, attributes, this._evaluationContext)) continue;
                String treatment = Splitter.getTreatment(bk, parsedSplit.seed(), parsedCondition.partitions(), parsedSplit.algo());
                config = this.getConfig(parsedSplit, treatment);
                return new TreatmentLabelAndChangeNumber(treatment, parsedCondition.label(), parsedSplit.changeNumber(), config, parsedSplit.impressionsDisabled());
            }
            config = this.getConfig(parsedSplit, parsedSplit.defaultTreatment());
            return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "default rule", parsedSplit.changeNumber(), config, parsedSplit.impressionsDisabled());
        }
        catch (Exception e) {
            throw new ChangeNumberExceptionWrapper(e, parsedSplit.changeNumber());
        }
    }

    private boolean checkRollout(boolean inRollout, ParsedCondition parsedCondition) {
        return !inRollout && parsedCondition.conditionType() == ConditionType.ROLLOUT;
    }

    private String getBucketingKey(String bucketingKey, String matchingKey) {
        return bucketingKey == null ? matchingKey : bucketingKey;
    }

    private String getConfig(ParsedSplit parsedSplit, String returnedTreatment) {
        return parsedSplit.configurations() != null ? parsedSplit.configurations().get(returnedTreatment) : null;
    }

    private String getFallbackConfig(FallbackTreatment fallbackTreatment) {
        if (fallbackTreatment.getConfig() != null) {
            return fallbackTreatment.getConfig();
        }
        return null;
    }

    private TreatmentLabelAndChangeNumber evaluateParsedSplit(String matchingKey, String bucketingKey, Map<String, Object> attributes, ParsedSplit parsedSplit, String featureName) {
        try {
            if (parsedSplit == null) {
                FallbackTreatment fallbackTreatment = this._fallbackTreatmentCalculator.resolve(featureName, "definition not found");
                return new TreatmentLabelAndChangeNumber(fallbackTreatment.getTreatment(), fallbackTreatment.getLabel(), null, this.getFallbackConfig(fallbackTreatment), false);
            }
            return this.getTreatment(matchingKey, bucketingKey, parsedSplit, attributes);
        }
        catch (ChangeNumberExceptionWrapper e) {
            _log.error("Evaluator Exception", (Throwable)e.wrappedException());
            FallbackTreatment fallbackTreatment = this._fallbackTreatmentCalculator.resolve(featureName, "exception");
            return new TreatmentLabelAndChangeNumber(fallbackTreatment.getTreatment(), fallbackTreatment.getLabel(), e.changeNumber());
        }
        catch (Exception e) {
            _log.error("Evaluator Exception", (Throwable)e);
            FallbackTreatment fallbackTreatment = this._fallbackTreatmentCalculator.resolve(featureName, "exception");
            return new TreatmentLabelAndChangeNumber(fallbackTreatment.getTreatment(), fallbackTreatment.getLabel());
        }
    }

    public static final class TreatmentLabelAndChangeNumber {
        public final String treatment;
        public final String label;
        public final Long changeNumber;
        public final String configurations;
        public final boolean track;

        public TreatmentLabelAndChangeNumber(String treatment, String label) {
            this(treatment, label, null, null, true);
        }

        public TreatmentLabelAndChangeNumber(String treatment, String label, Long changeNumber) {
            this(treatment, label, changeNumber, null, true);
        }

        public TreatmentLabelAndChangeNumber(String treatment, String label, Long changeNumber, String configurations, boolean track) {
            this.treatment = treatment;
            this.label = label;
            this.changeNumber = changeNumber;
            this.configurations = configurations;
            this.track = track;
        }
    }
}

