/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.client.dtos.Prerequisites;
import io.split.engine.evaluator.EvaluationContext;
import io.split.engine.matchers.Matcher;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class PrerequisitesMatcher
implements Matcher {
    private List<Prerequisites> _prerequisites;

    public PrerequisitesMatcher(List<Prerequisites> prerequisites) {
        this._prerequisites = prerequisites;
    }

    public List<Prerequisites> getPrerequisites() {
        return this._prerequisites;
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, EvaluationContext evaluationContext) {
        if (matchValue == null) {
            return false;
        }
        if (!(matchValue instanceof String)) {
            return false;
        }
        if (this._prerequisites == null) {
            return true;
        }
        for (Prerequisites prerequisites : this._prerequisites) {
            String treatment = evaluationContext.getEvaluator().evaluateFeature((String)((String)matchValue), (String)bucketingKey, (String)prerequisites.featureFlagName, attributes).treatment;
            if (prerequisites.treatments.contains(treatment)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("prerequisites: ");
        if (this._prerequisites != null) {
            bldr.append(this._prerequisites.stream().map(pr -> pr.featureFlagName + " " + pr.treatments.toString()).map(Object::toString).collect(Collectors.joining(", ")));
        }
        return bldr.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrerequisitesMatcher that = (PrerequisitesMatcher)o;
        return Objects.equals(this._prerequisites, that._prerequisites);
    }

    public int hashCode() {
        int result = this._prerequisites != null ? this._prerequisites.hashCode() : 0;
        result = 31 * result + (this._prerequisites != null ? this._prerequisites.hashCode() : 0);
        return result;
    }
}

