/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse;

import io.split.client.dtos.Split;
import io.split.engine.sse.NotificationProcessor;
import io.split.engine.sse.PushStatusTracker;
import io.split.engine.sse.dtos.CommonChangeNotification;
import io.split.engine.sse.dtos.GenericNotificationData;
import io.split.engine.sse.dtos.IncomingNotification;
import io.split.engine.sse.dtos.SegmentQueueDto;
import io.split.engine.sse.dtos.SplitKillNotification;
import io.split.engine.sse.dtos.StatusNotification;
import io.split.engine.sse.workers.FeatureFlagsWorker;
import io.split.engine.sse.workers.Worker;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public class NotificationProcessorImp
implements NotificationProcessor {
    private final FeatureFlagsWorker _featureFlagsWorker;
    private final Worker<SegmentQueueDto> _segmentWorker;
    private final PushStatusTracker _pushStatusTracker;

    @VisibleForTesting
    NotificationProcessorImp(FeatureFlagsWorker featureFlagsWorker, Worker<SegmentQueueDto> segmentWorker, PushStatusTracker pushStatusTracker) {
        this._featureFlagsWorker = Preconditions.checkNotNull(featureFlagsWorker);
        this._segmentWorker = Preconditions.checkNotNull(segmentWorker);
        this._pushStatusTracker = Preconditions.checkNotNull(pushStatusTracker);
    }

    public static NotificationProcessorImp build(FeatureFlagsWorker featureFlagsWorker, Worker<SegmentQueueDto> segmentWorker, PushStatusTracker pushStatusTracker) {
        return new NotificationProcessorImp(featureFlagsWorker, segmentWorker, pushStatusTracker);
    }

    @Override
    public void processUpdates(IncomingNotification notification) {
        this._featureFlagsWorker.addToQueue(notification);
    }

    @Override
    public void process(IncomingNotification notification) {
        notification.handler(this);
    }

    @Override
    public void processSplitKill(SplitKillNotification splitKillNotification) {
        this._featureFlagsWorker.kill(splitKillNotification);
        this._featureFlagsWorker.addToQueue(new CommonChangeNotification(GenericNotificationData.builder().changeNumber(splitKillNotification.getChangeNumber()).channel(splitKillNotification.getChannel()).build(), Split.class));
    }

    @Override
    public void processSegmentUpdate(long changeNumber, String segmentName) {
        this._segmentWorker.addToQueue(new SegmentQueueDto(segmentName, changeNumber));
    }

    @Override
    public void processStatus(StatusNotification statusNotification) {
        statusNotification.handlerStatus(this._pushStatusTracker);
    }
}

