/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.enums;

import java.util.HashMap;
import java.util.Map;

public enum CompressType {
    NOT_COMPRESSED(0),
    GZIP(1),
    ZLIB(2);

    private final Integer value;
    private static final Map<Integer, CompressType> _map;

    private CompressType(Integer value) {
        this.value = value;
    }

    public long getValue() {
        return this.value.intValue();
    }

    public static CompressType from(Integer value) {
        if (value == null || _map.size() <= value) {
            return null;
        }
        return _map.get(value);
    }

    static {
        _map = new HashMap<Integer, CompressType>();
        for (CompressType compressType : CompressType.values()) {
            _map.put(compressType.value, compressType);
        }
    }
}

