/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.hc.client5.http.impl.cookie;

import split.org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import split.org.apache.hc.client5.http.cookie.Cookie;
import split.org.apache.hc.client5.http.cookie.CookieOrigin;
import split.org.apache.hc.client5.http.cookie.MalformedCookieException;
import split.org.apache.hc.client5.http.cookie.SetCookie;
import split.org.apache.hc.client5.http.impl.cookie.AbstractCookieAttributeHandler;
import split.org.apache.hc.core5.annotation.Contract;
import split.org.apache.hc.core5.annotation.ThreadingBehavior;
import split.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    public static final BasicSecureHandler INSTANCE = new BasicSecureHandler();

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

