/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.hc.client5.http.ssl;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import split.org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import split.org.apache.hc.client5.http.ssl.HostnameVerificationPolicy;
import split.org.apache.hc.client5.http.ssl.HttpsSupport;
import split.org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import split.org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import split.org.apache.hc.core5.function.Factory;
import split.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import split.org.apache.hc.core5.http.ssl.TLS;
import split.org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import split.org.apache.hc.core5.reactor.ssl.TlsDetails;
import split.org.apache.hc.core5.ssl.SSLContexts;

public class ClientTlsStrategyBuilder {
    private SSLContext sslContext;
    private String[] tlsVersions;
    private String[] ciphers;
    private SSLBufferMode sslBufferMode;
    private HostnameVerificationPolicy hostnameVerificationPolicy;
    private HostnameVerifier hostnameVerifier;
    private boolean systemProperties;

    public static ClientTlsStrategyBuilder create() {
        return new ClientTlsStrategyBuilder();
    }

    public ClientTlsStrategyBuilder setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public final ClientTlsStrategyBuilder setTlsVersions(String ... tlslVersions) {
        this.tlsVersions = tlslVersions;
        return this;
    }

    public final ClientTlsStrategyBuilder setTlsVersions(TLS ... tlslVersions) {
        this.tlsVersions = new String[tlslVersions.length];
        for (int i = 0; i < tlslVersions.length; ++i) {
            this.tlsVersions[i] = tlslVersions[i].id;
        }
        return this;
    }

    public final ClientTlsStrategyBuilder setCiphers(String ... ciphers) {
        this.ciphers = ciphers;
        return this;
    }

    public ClientTlsStrategyBuilder setSslBufferMode(SSLBufferMode sslBufferMode) {
        this.sslBufferMode = sslBufferMode;
        return this;
    }

    @Deprecated
    public void setHostnameVerificationPolicy(HostnameVerificationPolicy hostnameVerificationPolicy) {
        this.hostnameVerificationPolicy = hostnameVerificationPolicy;
    }

    public ClientTlsStrategyBuilder setHostVerificationPolicy(HostnameVerificationPolicy hostnameVerificationPolicy) {
        this.hostnameVerificationPolicy = hostnameVerificationPolicy;
        return this;
    }

    public ClientTlsStrategyBuilder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    @Deprecated
    public ClientTlsStrategyBuilder setTlsDetailsFactory(Factory<SSLEngine, TlsDetails> tlsDetailsFactory) {
        return this;
    }

    public final ClientTlsStrategyBuilder useSystemProperties() {
        this.systemProperties = true;
        return this;
    }

    @Deprecated
    public TlsStrategy build() {
        return this.buildImpl();
    }

    public TlsStrategy buildAsync() {
        return this.buildImpl();
    }

    public TlsSocketStrategy buildClassic() {
        return this.buildImpl();
    }

    private DefaultClientTlsStrategy buildImpl() {
        HostnameVerificationPolicy hostnameVerificationPolicyCopy;
        String[] ciphersCopy;
        String[] tlsVersionsCopy;
        SSLContext sslContextCopy;
        if (this.sslContext != null) {
            sslContextCopy = this.sslContext;
        } else {
            SSLContext sSLContext = sslContextCopy = this.systemProperties ? SSLContexts.createSystemDefault() : SSLContexts.createDefault();
        }
        if (this.tlsVersions != null) {
            tlsVersionsCopy = this.tlsVersions;
        } else {
            Object object = tlsVersionsCopy = this.systemProperties ? HttpsSupport.getSystemProtocols() : null;
        }
        if (this.ciphers != null) {
            ciphersCopy = this.ciphers;
        } else {
            Object object = ciphersCopy = this.systemProperties ? HttpsSupport.getSystemCipherSuits() : null;
        }
        HostnameVerificationPolicy hostnameVerificationPolicy = this.hostnameVerificationPolicy != null ? this.hostnameVerificationPolicy : (hostnameVerificationPolicyCopy = this.hostnameVerifier == null ? HostnameVerificationPolicy.BUILTIN : HostnameVerificationPolicy.BOTH);
        HostnameVerifier hostnameVerifierCopy = this.hostnameVerifier != null ? this.hostnameVerifier : (hostnameVerificationPolicyCopy == HostnameVerificationPolicy.CLIENT || hostnameVerificationPolicyCopy == HostnameVerificationPolicy.BOTH ? HttpsSupport.getDefaultHostnameVerifier() : NoopHostnameVerifier.INSTANCE);
        return new DefaultClientTlsStrategy(sslContextCopy, tlsVersionsCopy, ciphersCopy, this.sslBufferMode != null ? this.sslBufferMode : SSLBufferMode.STATIC, hostnameVerificationPolicyCopy, hostnameVerifierCopy);
    }
}

