/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.hc.core5.util;

import java.util.Locale;
import split.org.apache.hc.core5.annotation.Internal;

public final class TextUtils {
    private TextUtils() {
    }

    public static boolean isEmpty(CharSequence s2) {
        return TextUtils.length(s2) == 0;
    }

    public static boolean isBlank(CharSequence s2) {
        int strLen = TextUtils.length(s2);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static boolean containsBlanks(CharSequence s2) {
        int strLen = TextUtils.length(s2);
        if (strLen == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(s2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int unsignedB = element & 0xFF;
            if (unsignedB < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toHexString(unsignedB));
        }
        return buffer.toString();
    }

    public static String toLowerCase(String s2) {
        if (s2 == null) {
            return null;
        }
        return s2.toLowerCase(Locale.ROOT);
    }

    public static boolean isAllASCII(CharSequence s2) {
        int strLen = TextUtils.length(s2);
        for (int i = 0; i < strLen; ++i) {
            if (s2.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    @Internal
    public static byte castAsByte(int c) {
        if (c >= 32 && c <= 126 || c >= 160 && c <= 255 || c == 9) {
            return (byte)c;
        }
        return 63;
    }
}

