/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.EventClient;
import io.split.client.dtos.Event;
import io.split.client.utils.GenericClientUtil;
import io.split.client.utils.Utils;
import io.split.telemetry.domain.enums.EventsDataRecordsEnum;
import io.split.telemetry.domain.enums.HTTPLatenciesEnum;
import io.split.telemetry.domain.enums.LastSynchronizationRecordsEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public class EventClientImpl
implements EventClient {
    public static final Long MAX_SIZE_BYTES = 0x500000L;
    private final BlockingQueue<WrappedEvent> _eventQueue;
    private final int _maxQueueSize;
    private final long _flushIntervalMillis;
    private final ExecutorService _senderExecutor;
    private final ExecutorService _consumerExecutor;
    private final ScheduledExecutorService _flushScheduler;
    static final Event CENTINEL = new Event();
    private static final Logger _log = LoggerFactory.getLogger(EventClientImpl.class);
    private final CloseableHttpClient _httpclient;
    private final URI _target;
    private final int _waitBeforeShutdown;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    ThreadFactory eventClientThreadFactory(String name) {
        return r -> new Thread(() -> {
            Thread.currentThread().setPriority(1);
            r.run();
        }, name);
    }

    public static EventClientImpl create(CloseableHttpClient httpclient, URI eventsRootTarget, int maxQueueSize, long flushIntervalMillis, int waitBeforeShutdown, TelemetryRuntimeProducer telemetryRuntimeProducer) throws URISyntaxException {
        return new EventClientImpl(new LinkedBlockingQueue<WrappedEvent>(maxQueueSize), httpclient, Utils.appendPath(eventsRootTarget, "api/events/bulk"), maxQueueSize, flushIntervalMillis, waitBeforeShutdown, telemetryRuntimeProducer);
    }

    EventClientImpl(BlockingQueue<WrappedEvent> eventQueue, CloseableHttpClient httpclient, URI target, int maxQueueSize, long flushIntervalMillis, int waitBeforeShutdown, TelemetryRuntimeProducer telemetryRuntimeProducer) throws URISyntaxException {
        this._httpclient = httpclient;
        this._target = target;
        this._eventQueue = eventQueue;
        this._waitBeforeShutdown = waitBeforeShutdown;
        this._maxQueueSize = maxQueueSize;
        this._flushIntervalMillis = flushIntervalMillis;
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
        this._senderExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(50), this.eventClientThreadFactory("eventclient-sender"), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                _log.warn("Executor queue full. Dropping events.");
            }
        });
        this._consumerExecutor = Executors.newSingleThreadExecutor(this.eventClientThreadFactory("eventclient-consumer"));
        this._consumerExecutor.submit(new Consumer());
        this._flushScheduler = Executors.newScheduledThreadPool(1, this.eventClientThreadFactory("eventclient-flush"));
        this._flushScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                EventClientImpl.this.flush();
            }
        }, this._flushIntervalMillis, this._flushIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public void flush() {
        this.track(CENTINEL, 0);
    }

    @Override
    public boolean track(Event event, int eventSize) {
        try {
            if (event == null) {
                return false;
            }
            if (this._eventQueue.offer(new WrappedEvent(event, eventSize))) {
                this._telemetryRuntimeProducer.recordEventStats(EventsDataRecordsEnum.EVENTS_QUEUED, 1L);
            } else {
                _log.warn("Event dropped.");
                this._telemetryRuntimeProducer.recordEventStats(EventsDataRecordsEnum.EVENTS_DROPPED, 1L);
            }
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            this._telemetryRuntimeProducer.recordEventStats(EventsDataRecordsEnum.EVENTS_DROPPED, 1L);
            _log.warn("Interruption when adding event withed while adding message %s.", (Object)event);
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        try {
            this._consumerExecutor.shutdownNow();
            this._flushScheduler.shutdownNow();
            this._senderExecutor.awaitTermination(this._waitBeforeShutdown, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            _log.warn("Error when shutting down EventClientImpl", (Throwable)e);
        }
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }

    static class EventSenderTask
    implements Runnable {
        private final List<Event> _data;
        private final URI _endpoint;
        private final CloseableHttpClient _client;

        static EventSenderTask create(CloseableHttpClient httpclient, URI eventsTarget, List<Event> events) {
            return new EventSenderTask(httpclient, eventsTarget, events);
        }

        EventSenderTask(CloseableHttpClient httpclient, URI eventsTarget, List<Event> events) {
            this._client = httpclient;
            this._data = events;
            this._endpoint = eventsTarget;
        }

        @Override
        public void run() {
            GenericClientUtil.process(this._data, this._endpoint, this._client);
        }
    }

    static class WrappedEvent {
        private final Event _event;
        private final long _size;

        public WrappedEvent(Event event, long size) {
            this._event = event;
            this._size = size;
        }

        public Event event() {
            return this._event;
        }

        public long size() {
            return this._size;
        }
    }

    class Consumer
    implements Runnable {
        Consumer() {
        }

        @Override
        public void run() {
            ArrayList<Event> events = new ArrayList<Event>();
            long accumulated = 0L;
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    WrappedEvent data = (WrappedEvent)EventClientImpl.this._eventQueue.take();
                    Event event = data.event();
                    Long size = data.size();
                    if (event != CENTINEL) {
                        events.add(event);
                        accumulated += size.longValue();
                    } else if (events.size() < 1) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug("No messages to publish.");
                        continue;
                    }
                    long initTime = System.currentTimeMillis();
                    if (events.size() < EventClientImpl.this._maxQueueSize && accumulated < MAX_SIZE_BYTES && event != CENTINEL) continue;
                    if (_log.isDebugEnabled()) {
                        _log.debug(String.format("Sending %d events", events.size()));
                    }
                    EventClientImpl.this._senderExecutor.submit(EventSenderTask.create(EventClientImpl.this._httpclient, EventClientImpl.this._target, events));
                    events = new ArrayList();
                    accumulated = 0L;
                    EventClientImpl.this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.EVENTS, System.currentTimeMillis() - initTime);
                    EventClientImpl.this._telemetryRuntimeProducer.recordSuccessfulSync(LastSynchronizationRecordsEnum.EVENTS, System.currentTimeMillis());
                }
            }
            catch (InterruptedException e) {
                _log.debug("Consumer thread was interrupted. Exiting...");
            }
        }
    }
}

