/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.LocalhostSplitFactory;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitFactory;
import io.split.client.SplitFactoryImpl;
import io.split.inputValidation.ApiKeyValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitFactoryBuilder {
    private static final Logger _log = LoggerFactory.getLogger(SplitFactoryBuilder.class);

    public static SplitFactory build(String apiToken) throws IOException, URISyntaxException {
        return SplitFactoryBuilder.build(apiToken, SplitClientConfig.builder().build());
    }

    public static synchronized SplitFactory build(String apiToken, SplitClientConfig config) throws IOException, URISyntaxException {
        ApiKeyValidator.validate(apiToken);
        if ("localhost".equals(apiToken)) {
            return LocalhostSplitFactory.createLocalhostSplitFactory(config);
        }
        return new SplitFactoryImpl(apiToken, config);
    }

    public static SplitFactory local() throws IOException, URISyntaxException {
        return LocalhostSplitFactory.createLocalhostSplitFactory(SplitClientConfig.builder().build());
    }

    public static SplitFactory local(SplitClientConfig config) throws IOException, URISyntaxException {
        return LocalhostSplitFactory.createLocalhostSplitFactory(config);
    }

    public static void main(String ... args) throws IOException, URISyntaxException {
        if (args.length != 1) {
            System.out.println("Usage: <api_token>");
            System.exit(1);
            return;
        }
        SplitClientConfig config = SplitClientConfig.builder().build();
        SplitClient client = SplitFactoryBuilder.build("API_KEY", config).client();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            while (line != null) {
                String[] userIdAndSplit;
                if ("exit".equals(line)) {
                    System.exit(0);
                }
                if ((userIdAndSplit = line.split(" ")).length != 2) {
                    System.out.println("Could not understand command");
                } else {
                    boolean isOn = client.getTreatment(userIdAndSplit[0], userIdAndSplit[1]).equals("on");
                    System.out.println(isOn ? "on" : "off");
                }
                line = reader.readLine();
            }
        }
        catch (IOException io) {
            _log.error(io.getMessage(), (Throwable)io);
        }
    }
}

